package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * The representation of an IDL operation declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLOpDecl extends IDLNamed, IDLScopeForming, IDLNode {

    /**
     * Returns true if this operation is declared as "oneway".
     * @return true, if operation is oneway
     */
    boolean isOneway();
    
    /**
     * Get the return type of this operation.
     * @return this operation's return type
     */
    IDLType getIDLType();

    
    /**
     * Get the name of this operation.
     * @return this operation's name
     */
    String getName();
    
    /**
     * Get the parameters of this operation.
     * @return Iterator over this operation's parameters
     */
    Iterator getParams();

    /**
     * Get the raises expression of this operation.
     * @return this operation's raises expression, null if there is none
     */
    IDLRaises getRaises();
    
    /**
     * Get the context expression of this operation.
     * @return this operation's context expression, null if there is none
     */
    IDLContext getContext();
}
