package org.aspectix.IDLparser.pub;


/**
 * The representation of an IDL operation declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLParamDecl extends IDLNamed, IDLNode {

    /**
     * Get the directional attribute of this parameter.
     * @return this parameter's directional attribute
     */
    String getAttribute();

    /**
     * Get the name of this parameter.
     * @return this parameter's name
     */
    String getName();

    /**
     * Get the type of this parameter.
     * @return this parameter's type
     */
    IDLType getIDLType();
}
