package org.aspectix.IDLparser.pub;

/**
 * The representation of an IDL scoped name as a
 * node of an abstract syntax tree.
 */
public interface IDLScopedName extends IDLType, IDLConst, IDLNode {

    /**
     * Get the type which is referenced by this scoped name
     * in the IDL-file.
     * @return type which is referenced by this scoped name
     */
    IDLType getReferencedType() throws IDLException;
       
    /**
     * Get the String representation of this scoped name.
     * @return this scoped name as String
     */
    String getText();
}
