package org.aspectix.IDLparser.pub;

/**
 * The representation of an IDL sequence declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLSequence extends IDLType, IDLNode {

    /**
     * Get the length of this sequence as defined in the IDL-file.
     * @return length of this sequence -- 0, if this sequence has 
     * no fixed length
     * @exception IDLException if the references in the abstract syntax tree
     *  containing this Array have not been completely resolved
     */
    int getLength() throws IDLException;
        
    /**
     * Get the contained type of this sequence.
     * @return the contained IDLType  
     */
    IDLType getIDLType() throws IDLException;

    /**
     * Returns true, if this sequence refers to a surrounding
     * type ("recursive type declaration").
     * @return true, if this sequence contains a recursive type
     * declaration
     */
    boolean recursiveReference();
}
