package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * Iterator which iterates over the elements of an
 * IDLScopeStack, which are Strings.
 */
public class IDLStackIterator implements Iterator {
    IDLScopeStack stack;
    IDLScopeStack helper = new IDLScopeStack();

    public IDLStackIterator(IDLScopeStack stack) {
        this.stack = (IDLScopeStack)stack.clone();
    }

    public boolean hasNext() {
        if(!(helper == null)) return true;
        else return false;
    }

    public Object next() {
        Object result = (Object) helper;
        if(stack.empty()) {
            helper = null;
        }
        else {
            helper = IDLScopeStack.createStack((String)stack.pop(),null).append(helper);
        }  
        return result;
    }

    /**
     * The remove method is not supported by this iterator.
     * @exception UnsupportedOperationException is always thrown.
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
