package org.aspectix.IDLparser.pub;

/**
 * The representation of an IDL string expression as a
 * node of an abstract syntax tree.
 */
public interface IDLString extends IDLType, IDLNode {

    /**
     * Get the defined length of this string.
     * @return this string's length -- 0, if this string has 
     * no fixed length
     * @exception IDLException if the references in the abstract syntax tree
     *  containing this Array have not been completely resolved
     */
    int getLength() throws IDLException;

    /**
     * Returns true, if this string expression is wide string.
     * @return true, if this is a "wstring" expression
     */
    boolean isWide();

}
