package org.aspectix.IDLparser.pub;

import java.io.*;
import java.util.*;

/**
 * Class to control IDLNode-Tracing. 
 * Tracing can be switched on and off and be printed to any desired PrintStream.
 */
public class IDLTracer {

    /* static flag false allows compiler optimization */
    private static final boolean TRACE = true;
    private boolean userTrace = false;
    private PrintStream out = System.err;

    
    /*** Singleton functionality ***/

    private static IDLTracer instance = null;

    private IDLTracer() {}

    /**
     * Get the single instance of this tracer.
     * @return this singleton-instance
     */
    public static IDLTracer instance() {
        if(instance == null) instance = new IDLTracer();
        return instance;
    }

    /**
     * Returns true, if tracing is switched on.
     * @return true, if tracing is enabled
     */
    public boolean tracing() {
        return (TRACE && userTrace);
    }
    
    /**
     * Enable tracing (default is off).
     */
    public void enableTracing() {
        userTrace = true;
    }

    /**
     * Set target stream for tracing.
     * @param out PrintStream where the trace shall end up
     */
    public void setTracing(PrintStream out) {
        this.out = out;
        userTrace = true;
    }

    /**
     * Print a String to the trace.
     * @param s String to be printed
     */
    public void print(String s) {
        out.print(s);
    }

    /**
     * Print a String to the trace and terminate the String
     * with the line separator.
     * @param s String to be printed
     */
    public void println(String s) { 
        out.println(s);
    }
}
