package org.aspectix.IDLparser.pub;

import java.util.*;

/**
 * The representation of any IDL type expression as a
 * node of an abstract syntax tree.
 */
public interface IDLType extends IDLNode {

    /**
     * Get the effective CORBA Type of this Node.
     * @return this type's effective type
     * @exception IDLException, if this typename is invalid.
     */
    IDLType getEffectiveType() throws IDLException;

    /**
     * Determine, if a value matches this type (is castable to this type)   
     * @param constExp any Node representing a value
     * @return value, which is represented by the constExp
     * @exception IDLException, if value doesn't fit the type
     */ 
    Object matchValue(IDLNode constExp) throws IDLException;

    /** 
     * Get the integer representation of this type as defined in 
     * IDLTypeUtil     
     * @return type id of this type
     */
    int getTypeId();
    
}
