package org.aspectix.IDLparser.pub;

/**
 * Class containing Integer-Representations of IDL-Types
 */
public class IDLTypeUtil {

    public static final int CHAR = 1;
    public static final int WCHAR = 2;
    public static final int BOOLEAN = 3;
    public static final int INTEGER = 4;
    public static final int FLOAT = 5;
    public static final int NATIVE = 6;
    public static final int ENUM = 7;
    public static final int STRUCT = 8;
    public static final int UNION = 9;
    public static final int SEQUENCE = 10;
    public static final int INTERFACE = 11;
    public static final int STRING = 12;
    public static final int WSTRING = 13;
    public static final int FIXED_CONST = 14;
    public static final int FIXED = 15;
    public static final int IDENTIFIER = 16;
    public static final int SCOPED_NAME = 17;
    public static final int ARRAY = 18;
    public static final int VALUETYPE = 19;
    public static final int SUPPORT = 20;
    public static final int UNKNOWN_BASETYPE = 0;

    /**
     * Get the String representation of a given type id.
     * @param typeId to be converted to String
     * @return String representation of the type
     */
    public static String toString(int typeId) {
        switch(typeId) {
        case CHAR: return "char";
        case STRING: return "string";
        case BOOLEAN: return "boolean";
        case INTEGER: return "integer";
        case FLOAT: return "floating point";  
        case FIXED: return "fixed";
        case FIXED_CONST: return "fixed const";
        case NATIVE: return "native";
        case ENUM: return "enum";
        case STRUCT: return "struct";
        case UNION: return "union";
        case SEQUENCE: return "sequence";
        case INTERFACE: return "interface";
        case IDENTIFIER: return "identifier";
        case SCOPED_NAME: return "scoped name";
        case ARRAY: return "array";
	case VALUETYPE: return "valuetype";
	case SUPPORT: return "support";
        case UNKNOWN_BASETYPE: return "unknown basetype";
        default: return "unknown"; 
        }
    }

}
