package org.aspectix.IDLparser.pub;

import java.util.Iterator;


/**
 * The representation of an IDL union declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLUnion extends IDLScopeForming, IDLNamed, IDLType, IDLNode {

    /**
     * Get all case expressions inside this union.
     * @return Iterator over this expression's cases
     */
    Iterator getCases();
    
    /**
     * Get the switch type of this union.
     * @return this union's switch type
     */
    IDLType getSwitchType();
    
    /**
     * Get the name of this union.
     * @return this union's name
     */
    String getName();

}
