package org.aspectix.IDLparser.pub;

import java.util.Iterator;

/**
 * The representation of an IDL valuetype declaration as a
 * node of an abstract syntax tree.
 */
public interface IDLValueType extends IDLScopeForming, IDLNamed, 
				      IDLType, IDLNode 
{
    
    /**
     * Get the name of this interface.
     * @return this interface's name
     */
    String getName();

    /**
     * Returns true, if this valuetype declaration is a forward declaration
     * @return true, if this is a forward declaration
     */
    boolean forwardDecl();

    /**
     * Returns true, if this valuetype declaration is declared with the keyword
     * "abstract"
     * @return true, if this is a abstract valuetype
     */
    boolean abstractvalue();

    /**
     * Returns true, if this valuetpye declaration is declared with the keyword
     * "custom"
     * @return true, if this is a custom valuetype
     */
    boolean custom();

    /**
     * Returns true, if this valuetype declaration is a boxed value
     * @return true, if this is a boxed valuetype
     */
    boolean boxed();
    
    /**
     * Get all value types, from which this value type inherits directly.
     * @return Iterator over this value type's direct base value types
     * @exception IDLException if references to base value type could not be resolved
     */
    Iterator getDirectBaseValueTypes() throws IDLException;
    
    /**
     * Return all interfaces which this value type supports directly.
     * @return Iterator over this value types's supported interfaces.
     */
    Iterator getSupportedInterfaces();
    
    /**
     * Return all members, which have been inherited by this interface 
     * and are visible (not-redefined).
     * @return Iterator over this interface's visible, inherited members
     */
    Iterator getVisibleMembers();
    
    /**
     * Return all members, which have been defined locally in this interface.
     * @return Iterator over this interface's locally defined members
     */
    Iterator getLocallyDefinedMembers();
}
