package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Structure of ArrayNode
                     ______Const ( = length)
   ArrayNode________|
                    |______Type
*/

public class ArrayNode extends IDLEntityNode implements IDLArray {
    
    private BigDecimal length = null;

    public ArrayNode() {  }

    public ArrayNode(Token tok) { 
        super(tok);   
        line = tok.getLine();
    }

    public String getText() { 
        return "array";
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.ARRAY;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack("array","::");
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING array in line "+getLine());
        super.resolveReferences();
        length = ((IDLConst)getFirstChild()).numberValue();
        LookupUtil.assertPositiveIntValue(length, getLine());/*getline*/
    }

    public boolean defined() { return true; }

    /* ArrayNode specific methods *******************************/

    public int getLength() throws IDLException {
        if(length == null) throwNotResolvedException();
        return length.intValue();
    }

    public IDLType getIDLType() {
        return (IDLType)getSecondChild();
    }

    /* Type Interface *****************************************/

    public IDLType getEffectiveType() throws IDLException {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                "): "+((IDLEntityNode)constExp).getText()+" cannot be assigned to array type ");
    }

    public int getTypeId() {
        return IDLTypeUtil.ARRAY;
    }

}
