package org.aspectix.IDLparser.tree;

import antlr.*;
import org.aspectix.IDLparser.pub.*;

/* Attribute structure:

   AttrNode________________ TypeSpecificaton
   (flag readonly)
   (text identifier)
           
*/

public class AttrNode extends IDLEntityNode implements IDLAttr {

    private boolean readonly = false;
    
    public AttrNode() {  }

    public AttrNode(Token tok) { 
        super(tok);
        line = tok.getLine(); 
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.ATTRIBUTE;
    }

    /*** Attribute specific methods ***/

    public void setReadonly() {
        readonly = true;
    }

    public boolean isReadonly() {
        return readonly;
    }

    public String getName() {
        return getText();
    }

    public IDLType getIDLType() {
        return (IDLType)getFirstChild();
    }

}
