package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

public class BaseTypeNode extends IDLEntityNode implements IDLBaseType {

    private static final BigInteger ONE = BigInteger.valueOf(1);

    private static final BigDecimal MAX_SHORT = new BigDecimal((1<<15)-1);     //2^15-1
    private static final BigDecimal MIN_SHORT = new BigDecimal(-(1<<15));      //-2^15
    private static final BigDecimal MAX_USHORT = new BigDecimal((1<<16)-1);    //2^16-1
    private static final BigDecimal MIN_USHORT = new BigDecimal(0);            //0
    private static final BigDecimal MAX_LONG = new BigDecimal((1<<31)-1);      //2^31-1
    private static final BigDecimal MIN_LONG  = new BigDecimal(-(1<<31));      //-2^31
    private static final BigDecimal MAX_ULONG = new BigDecimal((1L<<32)-1);     //2^32-1
    private static final BigDecimal MIN_ULONG = new BigDecimal(0);             //0
    private static final BigDecimal MAX_LONGLONG = new BigDecimal(ONE.shiftLeft(63).subtract(ONE)); //2^63-1
    private static final BigDecimal MIN_LONGLONG = new BigDecimal(ONE.shiftLeft(63).negate());  //-2^63
    private static final BigDecimal MAX_ULONGLONG = new BigDecimal(ONE.shiftLeft(64).subtract(ONE)); //2^64-1
    private static final BigDecimal MIN_ULONGLONG = new BigDecimal(0);         //0 
    private static final BigDecimal MAX_FLOAT =  
               new BigDecimal(ONE.shiftLeft(23).subtract(ONE).multiply(ONE.shiftLeft(127))); 
                                                                            //((2^23)-1)*(2^127)       
    private static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();        
    private static final BigDecimal MAX_DOUBLE = 
               new BigDecimal(ONE.shiftLeft(52).subtract(ONE).multiply(ONE.shiftLeft(1023))); //((2^52)-1)*(2^1023) 
    private static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();   
    private static final BigDecimal MAX_LONGDOUBLE = 
               new BigDecimal(ONE.shiftLeft(64).subtract(ONE).multiply(ONE.shiftLeft(16383))); //((2^64)-1)*(2^16383) 
    private static final BigDecimal MIN_LONGDOUBLE = MAX_LONGDOUBLE.negate();    


    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.BASETYPE;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack(getText(),"::");
    }

    /* BaseType specific methods ****************************/
    
    public boolean isVoid() {
        if(getText().equals("void")) return true;
        else return false;
    }

    public String getName() {
        return getText();
    }


    /* Type Interface ***************************************/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        if(!(constExp instanceof IDLConst)) 
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                   "): "+((IDLEntityNode)constExp).getText()+" cannot be assigned to type "+getText());
        
        if((getTypeId() == IDLTypeUtil.INTEGER) || (getTypeId() == IDLTypeUtil.FLOAT) || 
           (getTypeId() == IDLTypeUtil.FIXED_CONST)) {
            BigDecimal number = ((IDLConst)constExp).numberValue();  
            
            if(getTypeId() == IDLTypeUtil.INTEGER) {
                if(number.scale() != 0) 
                    throw new IDLException("error(line"+LocationInfo.getLocationInfo(constExp.getLine())+
                                           "): "+number.toString()+" is not an integer type");
            }
            String typeName = getText();
            if(typeName.equals("fixed")) {
                return number;
            }
            else if(typeName.equals("short")) {
                if((number.compareTo(MAX_SHORT) != 1) && (number.compareTo(MIN_SHORT) != -1)) return number;
            }
            else if(typeName.equals("unsigned_short")) {
                if((number.compareTo(MAX_USHORT) != 1) && (number.compareTo(MIN_USHORT) != -1)) return number;
            }
            else if(typeName.equals("unsigned_long")) {
                if((number.compareTo(MAX_ULONG) != 1) && (number.compareTo(MIN_ULONG) != -1)) return number;
            }
            else if(typeName.equals("long")) {
                if((number.compareTo(MAX_LONG) != 1) && (number.compareTo(MIN_LONG) != -1)) return number;
            }
            else if(typeName.equals("unsigned_long_long")) { 
                if((number.compareTo(MAX_ULONGLONG) != 1) && (number.compareTo(MIN_ULONGLONG) != -1))
                    return number;   
            }
            else if (typeName.equals("long_long")) {
                if((number.compareTo(MAX_LONGLONG) != 1) && (number.compareTo(MIN_LONGLONG) != -1)) 
                    return number;
            }
            else if(typeName.equals("float")) {
                if((number.compareTo(MAX_FLOAT) != 1) && (number.compareTo(MIN_FLOAT) != -1)) return number;
            }
            else if(typeName.equals("double")) {
                if((number.compareTo(MAX_DOUBLE) != 1) && (number.compareTo(MIN_DOUBLE) != -1)) return number;
            }
            else if(typeName.equals("long_double")) {
                if((number.compareTo(MAX_LONGDOUBLE) != 1) && (number.compareTo(MIN_LONGDOUBLE) != -1)) 
                    return number;
            }
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                   "): "+number.toString()+" exceeds range of type "+typeName);  
        }
        else  return ((IDLConst)constExp).stringValue(getTypeId());   
    }

    public int getTypeId() {
        String type = getText();
        if((type.indexOf("float") != -1) || (type.indexOf("double") != -1)) return IDLTypeUtil.FLOAT;
        else if((type.indexOf("short") != -1) || (type.indexOf("long") != -1)) return IDLTypeUtil.INTEGER;
        if(type.equals("char")) return IDLTypeUtil.CHAR;
        else if(type.equals("wchar")) return IDLTypeUtil.WCHAR;
        else if(type.equals("fixed")) return IDLTypeUtil.FIXED_CONST;
        else if(type.equals("boolean")) return IDLTypeUtil.BOOLEAN; 
        else return IDLTypeUtil.UNKNOWN_BASETYPE;
    }

    /*
      public void printTypeRanges() {
      System.err.println("------------ MAX VALUES ------------------");
      
      System.err.println("value MAX_SHORT: "+MAX_SHORT);    
      System.err.println("value MIN_SHORT: "+MIN_SHORT);    
      System.err.println("value MAX_USHORT: "+MAX_USHORT);   
      System.err.println("value MIN_USHORT: "+MIN_USHORT);   
      System.err.println("value MAX_LONG: "+MAX_LONG);     
      System.err.println("value MIN_LONG: "+MIN_LONG );    
      System.err.println("value MAX_ULONG: "+MAX_ULONG);    
      System.err.println("value MIN_ULONG: "+MIN_ULONG);    
      System.err.println("value MAX_LONGLONG: "+MAX_LONGLONG); 
      System.err.println("value MIN_LONGLONG: "+MIN_LONGLONG); 
      System.err.println("value MAX_ULONGLONG: "+MAX_ULONGLONG);
      System.err.println("value MIN_ULONGLONG: "+MIN_ULONGLONG);
      System.err.println("value MAX_FLOAT: "+MAX_FLOAT);    
      System.err.println("value MIN_FLOAT: "+MIN_FLOAT);    
      System.err.println("value MAX_DOUBLE: "+MAX_DOUBLE);   
      System.err.println("value MIN_DOUBLE: "+MIN_DOUBLE);   
      System.err.println("value MAX_LONGDOUBLE: "+MAX_LONGDOUBLE);
      System.err.println("value MIN_LONGDOUBLE: "+MIN_LONGDOUBLE+"\n");   
      System.err.println("system MAX_FLOAT: "+Float.MAX_VALUE);
      //System.err.println("system MIN_FLOAT: "+Float.MIN_VALUE);
      System.err.println("system MAX_DOUBLE: "+Double.MAX_VALUE);
      System.err.println("system MIN_DOUBLE: "+Double.MIN_VALUE);
      
      System.err.println("__________________________________________");
      }
    */
}


 
