package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import java.util.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Case Expression Structure

                 _____TypeSpec
                |
  CaseNode______|_____IDLEntityNode:"default" or ConstInterface with case
  (with text    |
   identifier)  |_____optional further ConstInterface (or "default")

*/

public class CaseNode extends IDLEntityNode implements IDLCase {

    public CaseNode() {  }

    public CaseNode(Token tok) { 
        super(tok); 
        line = tok.getLine();
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.CASE_EXP;
    }

    /* CaseNode specific methods ****************************************/
    
    /* Returns the node representing the type of this case */
    public IDLType getIDLType() {
        return (IDLType)getFirstChild();
    }

    public String getName() {
        return getText();
    }

    /* Returns an iterator over the values represented by */ 
    /* the discriminator nodes mapped to the given type   */
    public Iterator getDiscriminators(IDLType typeNode) throws IDLException {
        ArrayList discriminators = new ArrayList(); 
        IDLIterator iterator = iterator();
        IDLEntityNode next = null;
        
        iterator.next();
        while(iterator.hasNext()) {
            next = (IDLEntityNode)iterator.next();
            if(next instanceof IDLConst) { 
                discriminators.add(((IDLType)typeNode).matchValue(next));
            }
            else discriminators.add("default");
        }
        return discriminators.iterator();
    }
    

}
