package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import org.aspectix.IDLparser.pub.*;

/* Constant structure:
                       ____________ TypeSpecificaton
   ConstDefNode_______|
   (with text id)     |____________ ConstInterface (value to be assigned)
*/

public class ConstDefNode extends IDLEntityNode implements IDLConstDef {

    Object value = null;
    IDLType type = null;

    public ConstDefNode() {  }

    public ConstDefNode(Token tok) { 
        super(tok); 
        line = tok.getLine(); 
    }
    
    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.CONSTANT;
    } 

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING constant definition "
                                                                        +getScopedName()+" in line "+getLine());
        super.resolveReferences();
        type = ((IDLType)getFirstChild());
        value = type.matchValue(getSecondChild());
    }

    /* ConstNode specific methods ***************************************/

    public String getName() {
        return getText();
    }

    public IDLType getIDLType() throws IDLException {
        if(type == null) throwNotResolvedException();
        return type;
    }

    public Object getValue() throws IDLException {
        if(value == null) throwNotResolvedException();
        return value; 
    }
    
}
