package org.aspectix.IDLparser.tree;

import antlr.*;
import antlr.collections.*;
import java.math.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

public class ConstExpNode extends IDLEntityNode implements IDLConst {

    private static final int MIN_ACCURACY = 20;  // 64+2 bits <= Log_10(2^(64+2))
    private static final int MAX_ACCURACY = 9871; // Log_10(2^(MIN_ACCURACY+2^15)) =~ 9870.17

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.CONST_EXP; //Log_10(2^(64+2^15))+MIN_ACCURACY
    }

    /******** Const Interface ***********/
    
    public BigDecimal numberValue() throws IDLException {
        IDLIterator iterator = iterator();
        IDLEntityNode firstOp, secondOp = null;
        String result = null;
        String operation = getText();

        firstOp = (IDLEntityNode)iterator.next();
        if(iterator.hasNext()) {
            secondOp = (IDLEntityNode)iterator.next();
        }

        if(secondOp == null) {
            BigDecimal value = ((IDLConst)firstOp).numberValue();
            if(operation.equals("none") || operation.equals("+")) return value;
            else if(operation.equals("-")) return value.negate();
            else if(operation.equals("~")) {
                if(value.scale() != 0) 
                    throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): operation "+getText()+
                                           " may not be performed on "+value.toString());
                return new BigDecimal(value.unscaledValue().not(), 0);
            }
            else throw new IDLException("("+LocationInfo.getLocationInfo(getLine())+"): unknown operation to perform "+getText()+
                                           " on constant expression "+value.toString());
        }
        else {
            BigDecimal value1 = ((IDLConst)firstOp).numberValue();
            BigDecimal value2 = ((IDLConst)secondOp).numberValue();
            if(operation.equals("*")) {
                return value1.multiply(value2);
            }
            else if(operation.equals("/")) {
                int myScale = value1.scale() - value2.scale();
                if(myScale < 0) myScale = 0;
                myScale += MIN_ACCURACY;
                if(myScale > MAX_ACCURACY) myScale = MAX_ACCURACY;
                return value1.divide(value2, myScale, BigDecimal.ROUND_HALF_UP);
            }
            else if(operation.equals("+")) {
                return value1.add(value2);
            }
            else if(operation.equals("-")) {
                return value1.subtract(value2);
            }
            else if(value1.scale() != 0) {
                throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): operation "+getText()+
                                           " may not be performed on floating_pt expression "+value1.toString());
            }
            else if(value2.scale() != 0) {
                throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): operation "+getText()+
                                           " may not be performed on floating_pt expression "+value2.toString());
            }
            /* the following operations are only allowed for integers, */
            /* i.e. value1.scale() and value2.scale() are 0 here! */
            BigInteger ivalue1 = value1.unscaledValue();
            BigInteger ivalue2 = value2.unscaledValue();

            if(operation.equals("%")) { 
                return new BigDecimal(ivalue1.mod(ivalue2), 0);
            }
            else if(operation.equals("<<")) {
                return new BigDecimal(ivalue1.shiftLeft(ivalue2.intValue()), 0);
            }
            else if(operation.equals(">>")) {
                return new BigDecimal(ivalue1.shiftRight(ivalue2.intValue()), 0);
            }
            else if(operation.equals("&")) {
                return new BigDecimal(ivalue1.and(ivalue2), 0);
            }
            else if(operation.equals("|")) {
                return new BigDecimal(ivalue1.or(ivalue2), 0);
            }
            else if(operation.equals("^")) {
                return new BigDecimal(ivalue1.xor(ivalue2), 0); 
            } 
            else throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): unknown operation to perform "
                                        +getText()+" on constant expressions "+value1.toString()+
                                        " and "+value2.toString());
        }
    }

    public String stringValue(int literalType) throws IDLException {
        IDLIterator iterator = iterator();
        IDLConst firstOp = (IDLConst)iterator.next(); 

        //if(iterator.hasNext() || (!getText().equals("none"))) 
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(((IDLNode)firstOp).getLine())+
                               "): Can't assign this constant expression to type "+IDLTypeUtil.toString(literalType));
            //return (firstOp).stringValue(literalType);
    }
}
