package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.Iterator;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Context structure:

                 ____________ String Literal
                |
   ContextNode__|____________ ...
                |
                |
               ...
           
*/

public class ContextNode extends IDLEntityNode {

    public ContextNode(Token tok) { 
        super(tok);  
        line = tok.getLine();
    } 

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.CONTEXT;
    }

    public void resolveReferences() throws IDLException {
        
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING context expression in line "+getLine());
        
        super.resolveReferences();

        IDLIterator iterator =  iterator();

        IDLEntityNode literalNode;

        while(iterator.hasNext()) {
            literalNode = (IDLEntityNode)iterator.next(); 
            checkContextLiteral(literalNode);  //better use getStringValue() to check this
        }
    }

    public Iterator getLiterals() {
        return iterator();
    }

    private void checkContextLiteral(IDLEntityNode literalNode) throws IDLException {
        String text = literalNode.getText();
        char next;
        for(int i = 0; i < text.length(); i++) {
            next = text.charAt(i);
            if(next == '"') continue; 
            if(next == '_')  continue; 
            else if(next == '.')  continue; 
            else if(next == '*') {
                if(i == text.length()-2) continue;
                else throw new IDLException("error(line "+literalNode.getLine()+"): asterisk may only occur "+
                                            "at the end of a string in context expression");
            }
            else if((next >= 'a') && (next <= 'z'))  continue; 
            else if((next >= 'A') && (next <= 'Z'))  continue; 
            else if((next >= '0') && (next <= '9'))  continue; 
            else throw new IDLException("error(line "+literalNode.getLine()+"): strings in context "+
                                        "expressions may only contain alphabetic, digit, period, "+
                                        "underscore and asterisk characters");
        }
    }

}
