package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import java.util.Iterator;
import org.aspectix.IDLparser.util.*;
import org.aspectix.IDLparser.pub.*;

/* Enum Structure
                         _____Identifier
                        |
   EnumNode_____________|_____Identifier
   (with identifier)    |
                        |_____...
                        |
                       ...
*/

public class EnumNode extends IDLEntityNode implements IDLEnum {
    /* eumeration considered as own scope - not in specs! */

    private static final BigInteger MAX_ELEMENTS = BigInteger.valueOf((1L<<32)-1);

    public EnumNode() {  }

    public EnumNode(Token tok) { 
        super(tok);
        line = tok.getLine(); 
    }   
   
    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING enumeration "+getScopedName()+" in line "+getLine());
        super.resolveReferences();

        IDLIterator iterator = iterator();
        BigInteger counter = BigInteger.valueOf(0);
        while(iterator.hasNext()) {
            iterator.next();
            counter = counter.add(BigInteger.valueOf(1));
            if(counter.compareTo(MAX_ELEMENTS) == 1)
                throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+" enum "+getText()+
                                       " has more than "+MAX_ELEMENTS.toString()+" elements");
        }
    }

    public Iterator getNames() {
        return iterator();
    }

    public String getName() {
        return getText();
    }

    /*** Type Interface ***/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        if(constExp instanceof ScopedNameNode) {
            IDLIterator iterator = iterator();
            IDLScopedName next;
            IDLScopeStack stack;
            BigInteger counter = BigInteger.valueOf(0);
           
            while(iterator.hasNext()) {
                next = (IDLScopedName)iterator.next();
                stack = next.getScope();
                stack.push(next.getText());
                if(((IDLEntityNode)constExp).getScopedName().isShortReferenceTo(stack)) 
                    return counter;
                counter = counter.add(BigInteger.valueOf(1));
            }
            throw new IDLException("error( line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                   "): unknown enumeration value "+((IDLEntityNode)constExp).getText());
        }
        else throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                    "): "+((IDLEntityNode)constExp).getText()+" cannot be assigned to type enum "+getScopedName());
    }

    public int getTypeId() {
        return IDLTypeUtil.ENUM;
    }

}
