package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Structure of FixedNode
                    _____ConstExp    
   FixedNode_______|
                   |_____IntegerLiteral
*/

public class FixedNode extends IDLEntityNode implements IDLFixed { 

    private BigDecimal total = null;
    private BigDecimal fractional = null;
   
    public FixedNode() {  }

    public FixedNode(Token tok) { 
        super(tok);       
        line = tok.getLine(); 
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.FIXED;
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING fixed node in line "+getLine());
        super.resolveReferences();
        total = ((IDLConst)getFirstChild()).numberValue();
        fractional = ((IDLConst)getSecondChild()).numberValue();
        LookupUtil.assertPositiveIntValue(total, getLine());
    }

    /*** FixedNode specific methods ***/
    
    public int getTotal() throws IDLException {
        if(total == null) throwNotResolvedException();
        return total.intValue();
    }

    public int getFractional() throws IDLException {
        if(fractional == null) throwNotResolvedException();
        return fractional.intValue();
    }

    /*** Type Interface ***/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {   
        BigDecimal value = ((IDLConst)constExp).numberValue();
        return value;
    }

    public int getTypeId() {
        return IDLTypeUtil.FIXED;
    }

}
