package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

public class LiteralNode extends IDLEntityNode implements IDLConst {

    private static final int EXPONENT_RANGE = 9884; // Log_10(2^(64+2^15)) =~ 9883.42

    private int literalType;  

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.LITERAL;
    }

    /*** LiteralNode specific methods ***/

    public void setLiteralType(int literalType) {
        this.literalType = literalType;
    }

    public int getLiteralType() {
        return literalType;
    }

    /******** Const Interface ***********/

    public String stringValue(int type) throws IDLException { 
        if((literalType == IDLTypeUtil.CHAR) && ((type == IDLTypeUtil.CHAR) || (type == IDLTypeUtil.WCHAR)))  
            return charConvert(getText());
        else if((literalType == IDLTypeUtil.STRING) && ((type == IDLTypeUtil.STRING) || 
                                                        (type == IDLTypeUtil.WSTRING))) 
            return stringConvert(getText());
        else if(literalType == type) {     
            return getText();
        }
        else throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                    "): Can't assign constant expression "+getText()+" to type "
                                    +IDLTypeUtil.toString(type));
    }

    public BigDecimal numberValue() throws IDLException {
        try {
            String text = getText();
            //System.out.println("trying to get number from "+text);
            int pointIndex = text.indexOf(".");
            int expIndex = text.indexOf("e");
            if(expIndex == -1) expIndex = text.indexOf("E");
            
            /* fixed point */
            if((text.endsWith("d")) || (text.endsWith("D"))) {
                text = text.substring(0, text.length()-1);
                while(text.startsWith("0")) text = text.substring(1);
                while(text.endsWith("0")) text = text.substring(0, text.length()-1);
                return new BigDecimal(text);
            }
            /* hex */
            if(text.startsWith("0x") || text.startsWith("0X")) {
                //System.out.println("is hex value");
                text = text.substring(2);
                return new BigDecimal(new BigInteger(text, 16), 0);
            }
            /* floating point */
            if((pointIndex != -1) || (expIndex != -1)) {
                //System.out.println("is floating point value");
                
                /* read exponent */
                if(expIndex != -1) {
                    BigDecimal base = new BigDecimal(text.substring(0, expIndex));
                    int expo = Integer.parseInt(text.substring(expIndex+1));
                    
                    if(Math.abs(expo) > EXPONENT_RANGE)
                        throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                               "): literal "+getText()+" - exponent is too large");
                    return base.movePointRight(expo);
                }
                else 
                    return new BigDecimal(text);
            }
            /* octal */
            if(text.startsWith("0")) {
                if(text.length() == 1) return new BigDecimal(0);
                //System.out.println("is octal value");
                text = text.substring(1);
                return new BigDecimal(new BigInteger(text, 8), 0);
            }
            /* integer */
            //System.out.println("is integer value");
            return new BigDecimal(text);
        } catch (NumberFormatException n) {
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                   "): Can't interpret literal "+getText()+" as number");
        } 
    }

    private String charConvert(String text) throws IDLException {

        /* cut quotes */
        text = text.substring(1, text.length()-1);
        return replaceEsc(text);
    }

    private String stringConvert(String text) throws IDLException {

        /* cut quotes */
        text = text.substring(1, text.length()-1);
        if(text.equals("\\0")) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                                 "): Null character is not allowed in string literal - "
                                                 +"encountered "+getText());
        text = replaceEsc(text);

        /* merge concatenated strings */
        int index;           
        while((index = text.indexOf("\"\"")) != -1) 
            text = text.substring(0, index).concat(text.substring(index+2));
        return text;
    }

    private String replaceEsc(String text) throws IDLException { 
        String newString;
        int index, counter;
        int checkedUntilIndex = 0;

        while((index = text.indexOf("\\", checkedUntilIndex)) != -1) {
            switch(text.charAt(index+1)) {
            case '\\': newString = "\\"; break;
            case 'n': newString = "\n"; break;
            case 't': newString = "\t"; break;
            case 'v': newString = "\013"; break;
            case 'b': newString = "\b"; break;
            case 'r': newString = "\r"; break;
            case 'f': newString = "\f"; break;
            case 'a': newString = "\007"; break;
            case '?': newString = "?"; break;
            default: newString = null; 
            } 
            if(newString != null) {
                /* standard escape sequence of length 2, replace */
                text = text.substring(0,index)+newString+text.substring(index+2);
            }
            else {
                /* octal or hexadecimal character specification, replace */
                

/***** text = replaceCharValue(text, index); *****/
/* this was obviosly not such a good idea - please uncomment if it ever
   should make sense to call the conversion methods */

            }
            checkedUntilIndex = index+1;
        }   

        return text;
    }

    private String replaceCharValue(String text, int index) throws IDLException {
        int counter = 0;
        String oldString = null;

        /* hex value */
        if(text.charAt(index+1) == 'x') {
            /* count hex values after '/x' (max 2) */
            if((text.length() > index+2) && (isHex(text.charAt(index+2)))) {
                counter++;
                if((text.length() > index+3) && (isHex(text.charAt(index+3)))) counter++;
            }
            oldString = text.substring(index+2, index+counter+2);
            return text.substring(0, index)+valueReplace(oldString,16)+text.substring(index+counter+2);
        }

        /* octal value */
        else {
            /* count octal values after '\' (max 3) */
            if((text.length() > index+1) && (isOctal(text.charAt(index+1)))) {
                counter++;
                if((text.length() > index+2) && (isOctal(text.charAt(index+2)))) {
                    counter++;
                    if((text.length() > index+3) && (isOctal(text.charAt(index+3)))) counter++;
                }
            }
            oldString = text.substring(index+1, index+counter+1);
            return text.substring(0, index)+valueReplace(oldString,8)+text.substring(index+counter+1);
        }
    }

    private boolean isHex(char c) {
        if(('0' <= c) && (c <= '9')) return true;
        else if(('A' <= c) && (c <= 'F')) return true;
        else if(('a' <= c) && (c <= 'f')) return true;
        else return false;
    }
    
    private boolean isOctal(char c) {
        if(('0' <= c) && (c <= '7')) return true;
        else return false;
    }

    private String valueReplace(String s, int radix) throws IDLException {
        /* will only work up to \177 or \x7f */ 
        try {
            char[] c = new char[1];
            c[0] = (char)Integer.parseInt(s, radix);
            return new String(c);
        } catch (NumberFormatException n) {
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                   "): Escaped value "+s+" (base "+radix+") in literal "
                                   +getText()+" cannot be converted to char - "+
                                   n.getMessage());
        }
    }

}
