package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Native structure:

   NativeNode (with text name)    
          
*/

public class NativeNode extends IDLEntityNode implements IDLNative {
  
    public NativeNode() {  }

    public NativeNode(Token tok) { 
        super(tok);  
        line = tok.getLine();
    }
    
    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.NATIVE;
    }

    public String getName() {
        return getText();
    }

    /*** Type Interface ***/
    
    public IDLType getEffectiveType() { 
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                               "): "+((IDLEntityNode)constExp).getText()+
                               " cannot be assigned to type native "+getScopedName());
    }

    public int getTypeId() {
        return IDLTypeUtil.NATIVE;
    }

}
