package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Operation Declaration structure:

                  ____________ TypeSpecificaton
                 |
                 |____________ ParamDeclaration
   OpDeclNode____|
  (with ident    |____________ ParamDeclaration
and flag oneway) |
                 |____________ ...
                 |
                 |____________ optional RAISES
                 |
                 |____________ optional CONTEXT
           
*/

public class OpDeclNode extends IDLEntityNode implements IDLOpDecl {

    private boolean oneway = false;

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.OP_DECL;
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING operation "+getScopedName()+" in line "+getLine());
        super.resolveReferences();
        if(oneway && !(getFirstChild().getText().equals("void"))) 
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): oneway operation must "+
                                   "have void return type"); 
        IDLIterator i = iterator();
        IDLEntityNode next;
        while(i.hasNext()) {
            next = (IDLEntityNode)i.next();
            if(oneway && (next instanceof ParamDeclNode) &&
               (((ParamDeclNode)next).getAttribute().indexOf("out") != -1)) 
                throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): output parameter "+getText()+
                                       " occured in oneway operation");
        }
    }

    /*** OpDecl specific methods ***/

    public void setOneway() {
        oneway = true;
    }
    
    public boolean isOneway() {
        return oneway;
    }
    
    public IDLType getIDLType() {
        return (IDLType)getFirstChild();
    }
    
    public String getName() {
        return getText();
    }

    public Iterator getParams() {
        ArrayList params = new ArrayList();
        IDLIterator i = iterator();
        IDLEntityNode next;
        i.next();
        while(i.hasNext()) {
            next = (IDLEntityNode)i.next();
            if(!(next instanceof IDLParamDecl)) break;
            params.add(next);
        }
        return params.iterator();
    }


    public IDLRaises getRaises() {
        IDLIterator i = iterator();
        IDLEntityNode next;
        i.next();
        while(i.hasNext()) {
            next = (IDLEntityNode)i.next();
            if(next instanceof IDLRaises) return (IDLRaises)next;
        }
        return null;
    }
    
    public IDLContext getContext() {
        IDLIterator i = iterator();
        IDLEntityNode next;
        i.next();
        while(i.hasNext()) {
            next = (IDLEntityNode)i.next();
            if(next instanceof IDLContext) return (IDLContext)next;
        }
        return null;
    }

}

