package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.Iterator;
import org.aspectix.IDLparser.pub.*;
import java.util.*;

/* 
   SpecNode is the root node for an IDL specification.
   It just passes any method calls to its children.
*/

public class PreprocNode extends IDLEntityNode implements IDLPreproc {
    private String text;

    public PreprocNode() {  }
    public PreprocNode(Token tok) { 
        super(tok);
    }   

    public String getText() {
	return text;
    } 
    public void setText(String txt) {
	text = txt;
        if(!text.startsWith("# ")) return;	

	StringTokenizer sttok = new StringTokenizer(text);
	// Die erste Zeile des Prprozessor-Output lautet immer
	// '# 1 "XXX.idl", wobei XXX.idl der Haupt-Dateiname ist.
	if(LocationInfo.haupt=="leer"){
	    try {
		sttok.nextToken();   // skip '#'
		sttok.nextToken();   // skip master line (always '1')
		LocationInfo.haupt = sttok.nextToken();
	    } catch(NoSuchElementException ex) {
		throw new RuntimeException("PreprocNode: Unexpected hash line:\n"+
					   txt);
	    }
	}
	else{
	    String includefile;
	    int includelinenr;
	    try {
		sttok.nextToken();   // skip '#'
		includelinenr=Integer.parseInt(sttok.nextToken());
		includefile = sttok.nextToken();
	    } catch(NoSuchElementException ex) {
		throw new RuntimeException("PreprocNode: Unexpected hash line:\n"+
					   txt);
	    }

	    // Store new location information token in table
	    IDLTokinfo tinfo=new IDLTokinfo(includefile, includelinenr, getLine());
	    LocationInfo.offsetlist.add(tinfo);    
	}
    }


    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.PREPROC_DIRECTIVE;
    }

    protected IDLScopeStack getModifiedScope(IDLScopeStack scope) {
        IDLScopeStack s = (IDLScopeStack) scope.clone();
        s.push(getText());
        return s;
    }

    public void setScope() {
        setScope(new IDLScopeStack());
    }

    public Iterator getDefinitions() {
       return iterator();
    }
}


