package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Raises structure:

                ____________ Scoped_Name
               |
   RaisesNode__|____________ ...
               |
               |
              ...
           
*/

public class RaisesNode extends IDLEntityNode implements IDLRaises {
   
    public RaisesNode(Token tok) { 
        super(tok);  
        line = tok.getLine();
    } 

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.RAISES;
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING raises node "+getScopedName()+" in line "+getLine());
        super.resolveReferences();
        
        IDLIterator i =  iterator();

        IDLEntityNode name, expt;

        while(i.hasNext()) {
            name = (IDLEntityNode)i.next();
            expt = ((ScopedNameNode)name).getReference();
            if(!(expt instanceof IDLExcept) && !(expt instanceof IDLNative)) 
                throw new IDLException("error(line "+LocationInfo.getLocationInfo(name.getLine())+"): not an exception "+
                                       name.getText()+" - found "+expt.getClass().getName()+
                                       " in line "+LocationInfo.getLocationInfo(expt.getLine()));
        }
    }

    public Iterator getExceptions() throws IDLException {
        ArrayList list = new ArrayList();
        IDLIterator i =  iterator(); 
        while(i.hasNext()) {
            list.add(((ScopedNameNode)i.next()).getReference());
        }
        return list.iterator();
    }

}
