package org.aspectix.IDLparser.tree;

import java.util.*;
import antlr.*;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

public class ScopedNameNode extends IDLEntityNode implements IDLScopedName {
    
    private boolean scopeResolution = false;

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.SCOPED_NAME;
    }

    public String getLocalName() {
        int i = getText().lastIndexOf("::");
        if(i == -1) return getText();
        else  return getText().substring(i+2);
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack(getText(), "::");
    }

    
    boolean resolved = false;
    IDLEntityNode referencedNode = null;

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING scoped name "+
                                                                        getScopedName()+" in line "+getLine());
        if(!resolved) {
            resolved = true;
            if(!used()) return;
            if(shadowCopy()) 
                throw new IDLException("error (line "+LocationInfo.getLocationInfo(getLine())+"): scoped name "+
                                       getScopedName()+" resolved in shadow node");
            referencedNode = LookupUtil.instance().resolveReference(this);
        }
    }

    public IDLEntityNode getReference() throws IDLException {
        if(!resolved) throwNotResolvedException();
        if(referencedNode == null) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): name not found - "+getText());
        return referencedNode;
    }

    /*** ScopedNameNode specific methods ***/

    public void setScopeResolution() {
        scopeResolution = true;
    }

    public boolean scopeResolution() {
        return scopeResolution;
    }  

    public IDLType getReferencedType() throws IDLException {    
        if(!resolved) throwNotResolvedException();
        if(referencedNode == null) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): unknown type "+getText());
        if(!(referencedNode instanceof IDLType)) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                                                           "): not a type: "+getText());
        else return (IDLType)referencedNode;
    }

    boolean usesUnqualified(String name) {
        if(!used() || shadowCopy()) return false;  

        /* qualified form */
        if(getText().startsWith("::")) return false;

        /* check, if this scoped name contains the given string */
        IDLScopeStack self = getScopedName();
        while(!self.isEmpty()) {
            if(((String)self.pop()).equals(name)) {
                    return true;
            }
        }
        return false;
    }

    /******** Type Interface ***********/ 

    public IDLType getEffectiveType() throws IDLException {    
        if(!resolved) throwNotResolvedException();
        if(referencedNode == null) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): unknown type "+getText());
        if(!(referencedNode instanceof IDLType)) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                                                           "): not a type: "+getText());
        else return ((IDLType)referencedNode).getEffectiveType();
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        return ((IDLType)getEffectiveType()).matchValue(constExp);
    }
    

    public int getTypeId() {
        return IDLTypeUtil.SCOPED_NAME;
    }

    /******** Const Interface ***********/

    public String stringValue(int literalType) throws IDLException { 
        if(!resolved) throwNotResolvedException();
        if(referencedNode == null) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): unknown constant "+getText());
        if(!(referencedNode instanceof ConstDefNode)) 
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): not a constant: "+getText());
        IDLType myType = ((ConstDefNode)referencedNode).getIDLType().getEffectiveType();
        if((myType).getTypeId() != literalType) 
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                   "): "+getText()+" is not of type "+IDLTypeUtil.toString(literalType));
        return ((ConstDefNode)referencedNode).getValue().toString();
    }

    public BigDecimal numberValue() throws IDLException { 
        if(!resolved) throwNotResolvedException();
        if(referencedNode == null) throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): unknown constant "+getText());
        if(!(referencedNode instanceof ConstDefNode)) 
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+"): not a constant: "+getText());
        //IDLType myType = IDLType.toIDLType(((ConstDefNode)referencedNode).getEffectiveType());
        //int myTypeId = myType.getId();
        IDLType myType = ((ConstDefNode)referencedNode).getIDLType().getEffectiveType();
        int myTypeId = (myType).getTypeId();
        if((myTypeId != IDLTypeUtil.INTEGER) && (myTypeId != IDLTypeUtil.FLOAT) && (myTypeId != IDLTypeUtil.IDENTIFIER))
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                   "): expression "+getText()+
                                   " cannot be assigned to number type ");
        Object value = ((ConstDefNode)referencedNode).getValue();
        if(!(value instanceof BigDecimal))
            throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+
                                   "): constant expression "+value.toString()+
                                   " cannot be assigned to number type ");
        return (BigDecimal)value;
    }
    
}
