package org.aspectix.IDLparser.tree;

import java.util.*;
import antlr.*;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Structure of SequenceNode
                        ______TypeInterface
   SequenceNode________|
                       |______optional ConstExp
*/

public class SequenceNode extends IDLEntityNode implements IDLSequence {
    
    private boolean resolved = false;
    private BigDecimal length = null;
    private IDLType type = null;
    private boolean recursiveReference = false;

    public SequenceNode() {  }

    public SequenceNode(Token tok) { 
        super(tok);   
        line = tok.getLine();
    }

    public String getText() { 
        return "sequence";
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.SEQUENCE;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack("sequence","::");
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING sequence "+getScopedName()+" in line "+getLine());
        super.resolveReferences();
        if(getFirstChild() instanceof ScopedNameNode) {
            recursiveReference = true;
            IDLEntityNode found = LookupUtil.instance().resolveRecursiveReference((IDLEntityNode)getFirstChild());
            if((found != null) && (!(found instanceof IDLType))) 
                throw new IDLException("error (line "+LocationInfo.getLocationInfo(((IDLEntityNode)getFirstChild()).getLine())
                                       +"): not a type: "+getFirstChild().getText());
            type = (IDLType)found;
        }
        if(type == null)  {
            recursiveReference = false;
            type = ((IDLType)getFirstChild());
            type.getEffectiveType();
        }
        if(getSecondChild() != null) {
            length = ((IDLConst)getSecondChild()).numberValue();
            LookupUtil.assertPositiveIntValue(length, getLine());
        }
        resolved = true;
    }

    /*** SequenceNode specific methods ***/

    public int getLength() throws IDLException {
        if(!resolved) throwNotResolvedException();
        if(length == null) return 0;
        else return length.intValue();
    }

    public IDLType getIDLType() throws IDLException {  
        if(!resolved) throwNotResolvedException();
        return type;
    }

    public boolean recursiveReference() {
        return recursiveReference;
    }

    /*** Type Interface ***/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                "): "+((IDLEntityNode)constExp).getText()+
                                       " cannot be assigned to sequence type ");
    }

    public int getTypeId() {
        return IDLTypeUtil.SEQUENCE;
    }


}
