package org.aspectix.IDLparser.tree;

import java.util.*;
import antlr.*;
import java.math.BigDecimal;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Structure of StringNode
                     
   StringNode________optional ConstExp
                   
*/

public class StringNode extends IDLEntityNode implements IDLString { 

    private boolean resolved = false;
    private BigDecimal length = null;
   
    public StringNode() {  }

    public StringNode(Token tok) { 
        super(tok);       
        line = tok.getLine(); 
    }

    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.STRING;
    }

    public IDLScopeStack getScopedName() {
        return IDLScopeStack.createStack("string","::");
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing()) IDLTracer.instance().println("RESOLVING string in line "+getLine());
        if(getFirstChild() != null) {
            length = ((IDLConst)getFirstChild()).numberValue();
            LookupUtil.assertPositiveIntValue(length, getLine());
        }
        resolved = true;
    }

    /*** StringNode specific methods ***/

    public int getLength() throws IDLException {
        if(!resolved) throwNotResolvedException();
        if(length == null) return 0;
        else return length.intValue();
    }

    public boolean isWide() {
        return getText().equals("wstring");
    }

    /*** Type Interface ***/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        Object value = ((IDLConst)constExp).stringValue(getTypeId());
        if(length == null) return value;
        else {
            String strval = (String) value; 
            if(length.compareTo(new BigDecimal(strval.length())) >= 0) return value;  
            else throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                        "): "+((IDLEntityNode)constExp).getText()+
                                        " cannot be assigned to string type of length "
                                        +length);
        }
    }

    public int getTypeId() {
        if(getText().equals("wstring")) return IDLTypeUtil.WSTRING;
        else return IDLTypeUtil.STRING;
    }


}
