package org.aspectix.IDLparser.tree;

import java.util.*;
import antlr.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Structure of StructNode
                         ______TypeDecl
                        |
   StructNode___________|______optional TypeDecl
   (with identifier)    |
                        |______...
                        |
                       ...

*/

public class StructNode extends IDLEntityNode implements IDLStruct {

    public StructNode() {  }

    public StructNode(Token tok) { 
        super(tok); 
        line = tok.getLine();
    }
    
    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.STRUCTURE;
    }
  
    public Iterator getMembers() {
        return iterator();
    }

    public String getName() {
        return getText();
    }

    /*** Type Interface ***/
    
    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                "): "+((IDLEntityNode)constExp).getText()+
                               " cannot be assigned to struct type ");
    }

    public int getTypeId() {
        return IDLTypeUtil.STRUCT;
    }

}
