package org.aspectix.IDLparser.tree;

import antlr.*;
import org.aspectix.IDLparser.pub.*;

/* Typedef structure:

  TypedefNode__________TypeSpecification
  (with identifier)              

*/



public class TypedefNode extends IDLEntityNode implements IDLTypedef {

    public TypedefNode() {  }

    public TypedefNode(Token tok) { super(tok); }
    
    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.TYPEDEF;
    }    

    public String getName() {
        return getText();
    }

    public IDLType getIDLType() {
        return (IDLType)getFirstChild();
    }

    /*** TypeInterface ***/

    public IDLType getEffectiveType() throws IDLException {
        return ((IDLType)getFirstChild()).getEffectiveType();
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        return ((IDLType)getFirstChild()).matchValue(constExp);
    }

    public int getTypeId() {
        return ((IDLType)getFirstChild()).getTypeId();
    }   
}
