package org.aspectix.IDLparser.tree;

import antlr.*;
import java.math.*;
import java.util.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Union Structure
                          _____Type Spec. (for switch - integer, char, boolean, enum or scoped name)
                         |
   UnionNode_____________|_____CaseNode
   (with identifier)     |
                         |_____...
                         |
                        ...
*/

public class UnionNode extends IDLEntityNode implements IDLUnion {

    private IDLType switchType = null;

    public UnionNode() {  }

    public UnionNode(Token tok) { 
        super(tok);  
        line = tok.getLine(); 
    }
    
    public int getType() {
        return org.aspectix.IDLparser.grammar.IDLTokenTypes.UNION;
    }

    public void resolveReferences() throws IDLException {
        if(IDLTracer.instance().tracing())
            IDLTracer.instance().println("RESOLVING union "+getScopedName()+" in line "+getLine());
        super.resolveReferences();

        IDLIterator i = iterator();
        switchType = ((IDLType)i.next()).getEffectiveType();

        TreeSet discriminators = new TreeSet(new IDLConstantComparator());
        Iterator discs;
        IDLEntityNode nextCase, nextDisc;
        Object value;

        while(i.hasNext()) {
            nextCase = (IDLEntityNode)i.next();
            discs = ((CaseNode)nextCase).getDiscriminators(switchType);
            while(discs.hasNext()) { 
                value = (Object)discs.next();
                if(discriminators.add(value) == false)
                    throw new IDLException("error(line "+LocationInfo.getLocationInfo(getLine())+") case label "+value.toString()+
                                           " occured twice in union "+getScopedName());
            }
        }
    }

    public Iterator getCases() {
        Iterator i = iterator();
        i.next();
        return i;
    }

    public IDLType getSwitchType() {
        return (IDLType)getFirstChild();
    }

    public String getName() {
        return getText();
    }


    /*** Type Interface ***/

    public IDLType getEffectiveType() {
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                                "): "+((IDLEntityNode)constExp).getText()+
                               " cannot be assigned to type union "+getScopedName());
    }

    public int getTypeId() {
        return IDLTypeUtil.UNION;
    }

}
