package org.aspectix.IDLparser.tree;

import antlr.*;
import java.util.*;
import org.aspectix.IDLparser.grammar.*;
import org.aspectix.IDLparser.pub.*;
import org.aspectix.IDLparser.util.*;

/* Interface structure:

                          ____________ optional InheritNode *
			 |
			 |____________ optional SupportNode *
                         |
                         |    ________ optional Operation Declaration (export) *
   InterfNode____________|   |
   (with text id         |___|________ optional state Declaration (state_decl) *
   and flags:                |
     custom,                 |________ optional factory declaration (init_decl) *
     abstract,            
     boxed, forward decl.)

   a) regular value:   boxed==forwarddecl==abstract==false, all fields allowed
   b) boxed value:     boxed==true  *==false,
                       no fields except one public state_decl entry
   c) abstract value:  abstract==true, *==false, InheritNode, SupportNode, export
                       no state_decl or init_decl
   d) forward decl:    forwarddecl=true, custom==boxed==false; no fields
           
*/
public class ValueTypeNode extends IDLEntityNode implements IDLValueType
{
    private boolean forwardDecl = false;
    private boolean abstractvalue = false;
    private boolean custom = false;
    private boolean boxed = false;
    private boolean inherits = false;
    private boolean supports = false;

    public ValueTypeNode(Token tok) { 
        super(tok);  
        line = tok.getLine();
    }

    /*** Type Interface ***/

    public IDLType getEffectiveType() { 
        return this;
    }

    public Object matchValue(IDLNode constExp) throws IDLException {
        throw new IDLException("error(line "+LocationInfo.getLocationInfo(constExp.getLine())+
                               "): "+((IDLEntityNode)constExp).getText()+
                               " cannot be assigned to type valuetye "+getScopedName());
    }

    public int getTypeId() {
        return IDLTypeUtil.VALUETYPE;
    }



    /*** ValueTypeNode specific methods ***/


    public void setForwardDecl() {
        forwardDecl = true;
    }

    public boolean forwardDecl() {
        return forwardDecl;
    }

    public void setAbstractValue() {
	abstractvalue = true;
    }

    public boolean abstractvalue() {
	return abstractvalue;
    }

    public void setCustom() {
	custom = true;
    }

    public boolean custom() {
	return custom;
    }

    public void setBoxed() {
	boxed = true;
    }

    public boolean boxed() {
	return boxed;
    }

    public void setInherits() {
       inherits = true;
    }

    public boolean inherits() {
       return inherits;
    }

    public void setSupports() {
       supports = true;
    }

    public boolean supports() {
       return supports;
    }
 
    public String getName() {
        return getText();
    }

    /**
     * Get all direct base value types of this value type
     * @return Iterator over the value types
     */
    public Iterator getDirectBaseValueTypes() throws IDLException {
        ArrayList list = new ArrayList();
	return list.iterator();

	/* TODO:
        if(!inheritis) return list.iterator();

        // our first child is the inherit node 
        IDLIterator iterator = ((IDLEntityNode)getFirstChild()).iterator(); 
        ScopedNameNode next;
        
        while(iterator.hasNext()) {    
            next = (ScopedNameNode)iterator.next();
            list.add(next.getReference());
        }
        return list.iterator();
	*/
    }

    /**
     * Return all interfaces which this value type supports directly.
     * @return Iterator over this value types's supported interfaces.
     */
    public Iterator getSupportedInterfaces() {
	// TODO
	return (new ArrayList()).iterator();

        /* TODO:
        if(!supports) return list.iterator();

        // our (first or) second child is the inherit node 
        IDLEntityNode node = (IDLEntityNode)getFirstChild();
	if(inherits) node=(IDLEntityNode)(node.next());

        IDLIterator iterator = node.iterator();
        ScopedNameNode next;

        while(iterator.hasNext()) {
            next = (ScopedNameNode)iterator.next();
            list.add(next.getReference());
        }
        return list.iterator();
        */

    }
    
    /**
     * Return all members, which have been inherited by this interface 
     * and are visible (not-redefined).
     * @return Iterator over this interface's visible, inherited members
     */
    public Iterator getVisibleMembers() {
	// TODO
	return (new ArrayList()).iterator();
    }
    
    /**
     * Return all members, which have been defined locally in this interface.
     * @return Iterator over this interface's locally defined members
     */
    public Iterator getLocallyDefinedMembers() { 
	// TODO
	return (new ArrayList()).iterator();
    }
}
