package org.aspectix.IDLparser.util;

import java.util.Iterator;
import org.aspectix.IDLparser.tree.*;

/**
 * Iterator over an AST node, holding 
 * all children of the node
 */
public class IDLIterator implements Iterator {

    private IDLEntityNode node = null;
    private IDLEntityNode currentChild = null;

    public IDLIterator(IDLEntityNode node) {
        this.node = (IDLEntityNode)node;
    }

    public boolean hasNext() {
        if(node == null) return false;
        if((currentChild == null) && (node.getFirstChild() != null)) return true;
        else if(currentChild == null) return false;
        else if(currentChild.getNextSibling() != null) return true;
        else return false;
    }

    public Object next() {
        if(currentChild != null) {
            currentChild = (IDLEntityNode) currentChild.getNextSibling();
            return currentChild;
        }
        else {
            currentChild = (IDLEntityNode) node.getFirstChild();
            return currentChild;
        }
    }

    public void remove() {
        //not used
    }

}
