package org.aspectix.IDLparser.util;

/* Originally DumpASTVisitor: ***************************/

/* ANTLR Translator Generator
 * Project led by Terence Parr at http://www.jGuru.com
 * Software rights: http://www.antlr.org/RIGHTS.html
 *
 * $Id: IDLTreeVisitor.java,v 1.1 2001/11/13 12:28:55 reiser Exp $
 */

/* modified by Andrea Nenni *************************/

import java.io.*;
import antlr.collections.AST;
import org.aspectix.IDLparser.tree.*;

/** Simple class to dump the contents of an AST to the output */
public class IDLTreeVisitor implements antlr.ASTVisitor {
    protected int level = 0;


    private void tabs() {
	for (int i = 0; i < level; i++) {
	    System.out.print("   ");
	}
    }

    public void visit(AST node) {
	AST node2; 
        
	for (node2 = node; node2 != null; node2 = node2.getNextSibling()) {
	    
            /* go to correct tab position */
            tabs();
            /* print text and type */
            if ( node2.getText()==null ) {
                System.out.print("nil");
            }
            else {
                System.out.print(node2.getText());
            }      
            System.out.print(" ["+node2.getType()+"] = "+
                             node2.getClass().getName().substring(12,node2.getClass().getName().length()-4)
                             +" ("+((IDLEntityNode)node2).getLine()+" - "+((IDLEntityNode)node2).sequence()+")");
            //if(((IDLEntityNode)node2).getFather() != null)
            //    System.out.print(" ["+((IDLEntityNode)node2).getFather().getText()+"]");
            //else System.out.print(" [nil]");
            System.out.println("");
            
            /* if there are childs, call visit recursively */
	    if ( node2.getFirstChild() != null ) {
		level++;
		visit(node2.getFirstChild());
		level--;
	    }
	}

    }
}
