/*
 * IDLflex -- A flexible, generic code generator for CORBA IDL
 *
 * Copyright (C) 2000  Hans Reiser, AspectIX Research Team
 *                     University of Erlangen-Nuernberg, Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 * The full text of the license can be found in the LICENSE.txt file.
 *
 * $Id: IBMXMLparser.java,v 1.1 2001/11/09 13:44:01 aanenni Exp $
 */

package org.aspectix.xmlparser;

import org.xml.sax.*;
import java.io.*;
import org.w3c.dom.Document;
import org.aspectix.AspectixException;
import org.apache.xerces.parsers.DOMParser;

/** XML parser implementation which uses the IBM XML4J (Xerces) XML parser.
 */
public class IBMXMLparser implements XMLparser
{
    private DOMParser p = null;

    public IBMXMLparser(EntityResolver entityResolver) throws AspectixException {
        p = new DOMParser();
        p.setEntityResolver(entityResolver);
        p.setErrorHandler(new XMLErrorHandler());
        try {
            p.setFeature("http://xml.org/sax/features/validation",true);
            p.setFeature("http://apache.org/xml/features/validation/schema",true);
        } catch (org.xml.sax.SAXNotRecognizedException r) {
            throw new AspectixException("Exception while setting up XML parser: "+r.getMessage());
        } catch (org.xml.sax.SAXNotSupportedException s) {
            throw new AspectixException("Exception while setting up XML parser: "+s.getMessage());
        }
    }

    public Document parse(String configFile) throws AspectixException {
        try {
            if(p == null)
                throw new AspectixException("IBMXMLparser: parser has not been well initialized");
            p.parse(new org.xml.sax.InputSource(new FileReader(configFile)));
            return p.getDocument();
        } catch (SAXParseException err) {
	    throw new AspectixException("*** Parsing error: line "+
				       err.getLineNumber()+", uri "+
				       err.getSystemId()+"\n  "+
				       err.toString());
	} catch (org.xml.sax.SAXException s) {
            Exception   x = s.getException ();
	    throw new AspectixException("*** Parser exception:\n"+
				       ((x == null) ? s : x).toString());
        } catch (IOException i) {
            throw new AspectixException("IBMXMLparser: "+i.getMessage());
        }
    }

    /** 
     * Check, if a given XML-expression (containing its definiton-file -- dtd or xsd) 
     * is valid
     * @param stream containing the expression to be verified
     * @return null if the expression is valid, else a String containing the error message
     */
    public String verify(String s) throws AspectixException {
        try {
            if(p == null)
                throw new AspectixException("IBMXMLparser: parser has not been well initialized");
            p.parse(new InputSource(new StringReader(s)));
            return null;
        } catch (IOException i) {
            throw new AspectixException("validateWeaveletParams: Unexpected IO-Exception occured: "+
                                       i.getMessage());
        } catch (SAXException p) {
            return p.getMessage();
	}
    }

    public Document parseString(String s) throws AspectixException {
        try {
            if(p == null)
                throw new AspectixException("IBMXMLparser: parser has not been well initialized");
            p.parse(new org.xml.sax.InputSource(new StringReader(s)));
            return p.getDocument();
        } catch (SAXParseException err) {
	    throw new AspectixException("*** Parsing error: line "+
				       err.getLineNumber()+", uri "+
				       err.getSystemId()+"\n  "+
				       err.toString());
	} catch (org.xml.sax.SAXException se) {
            Exception   x = se.getException ();
	    throw new AspectixException("*** Parser exception:\n"+
				       ((x == null) ? se : x).toString());
        } catch (IOException i) {
            throw new AspectixException("IBMXMLparser: "+i.getMessage());
        }
    }

}
