package org.aspectix.xmlparser;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ErrorHandler;

/** As the default behavior of the IBM SAX Parser
 *  is to ignore errors and warnings, this
 *  ErrorHandler is used to create an Exception for all errors
 *  and a message on stderr for warnings. */

public class XMLErrorHandler implements ErrorHandler {
    public void error(SAXParseException exception) 
        throws SAXParseException
	{
	    throw exception;
	}
    public void fatalError(SAXParseException exception) 
        throws SAXParseException
	{
	    throw exception;
	}
    public void warning(SAXParseException exception) {
        System.err.println(exception);
	}
}
