package org.aspectix.xmlparser;   

import java.io.*;
import java.util.*;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.aspectix.*;
import java.net.URL;

/** As Xerces by default just searches for Mapping.dtd in the
 *  current directory, this EntityResolver when lookup up the
 *  DTD file tries a) to find it in the same directory as the
 *  XML docuemnt b) to find it in $(IDLflexHome)/mapping/.
 */
public class XSDEntityResolver implements EntityResolver {
            
    private String xsdpath = AspectixEnvironment.XSD_DIR;
    private CachingFileLocator fileLocator = new CachingFileLocator(xsdpath);
    private static Hashtable results = new Hashtable();

    public InputSource resolveEntity(String pubID, String sysID) {
        if(sysID.endsWith(".xsd")) {
            try {
                URL url = fileLocator.findFile(new File(sysID).getName());
                if(url == null) throw new AspectixException();
                InputSource result = new InputSource(new BufferedInputStream(url.openStream(), 16384));
                result.setSystemId(url.toString());
                return result;
            } catch(AspectixException e) {
                System.err.println("XSDEntityResolver: "+sysID+" not found"+
                                   "in search path:\n"+xsdpath);
            } catch(IOException e) {
                System.err.println("XSDEntityResolver: "+sysID+" not found"+
                                   "in search path:\n"+xsdpath);
            }
        }
        return null;
    }

}
