#ifndef _UTIL_
#define _UTIL_

#include <stdlib.h>

/***********************/
/* one-argument macros */
/***********************/
#ifdef ABS
#undef ABS
#endif
#define ABS(a)		(((a)<0) ? -(a) : (a))

#ifdef MAX
#undef MAX
#endif
#define  MAX(a, b)      ( (a) > (b) ? (a) : (b) )
#ifdef MIN
#undef MIN
#endif
#define  MIN(a, b)      ( (a) < (b) ? (a) : (b) )

/* round a to nearest integer towards 0 */
#define FLOOR(a)		((a)>0 ? (int)(a) : -(int)(-a))

/* round a to nearest integer away from 0 */
#define CEILING(a) \
((a)==(int)(a) ? (a) : (a)>0 ? 1+(int)(a) : -(1+(int)(-a)))

/* round a to nearest int */

#ifndef ROUND
#define ROUND(a)	((a)>0 ? (int)((a)+0.5) : -(int)(0.5-(a)))		
#endif

/* take sign of a, either -1, 0, or 1 */
#define ZSGN(a)		(((a)<0) ? -1 : (a)>0 ? 1 : 0)	

/* take binary sign of a, either -1, or 1 if >= 0 */
#define SGN(a)		(((a)<0) ? -1 : 1)

/* square a */
#define SQR(a)		((a)*(a))	


/***********************/
/* two-argument macros */
/***********************/

/* swap a and b (see Gem by Wyvill) */
#define SWAP(a,b)	{ a^=b; b^=a; a^=b; }

/* linear interpolation from l (when a=0) to h (when a=1)*/
/* (equal to (a*h)+((1-a)*l) */
#define LERP(a,l,h)	((l)+(((h)-(l))*(a)))

/* clamp the input to the specified range */
#define CLAMP(v,l,h)	((v)<(l) ? (l) : (v) > (h) ? (h) : v)


#ifdef DEFINE_GLOBALS
#define GLOBAL
#define INIT(x) = x
#else
#define GLOBAL extern
#define INIT(x)
#endif


#ifndef NEW
#define NEW(x) (x *) malloc (sizeof(x))
#endif
#define NEWELEMS(x,n) (x *) malloc ((n)*sizeof(x))

#define MAX_NEG_CROP 384
#define NUM_CROP_ENTRIES (256+2*MAX_NEG_CROP)

#define ROUNDCROP(val) (cropTbl[MAX_NEG_CROP+(int)(val)])
#define CROP(val)      (cropTbl[MAX_NEG_CROP+(val)])

#endif /* _UTIL_ */
