/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        block.h
 *
 * Author:      K.S, T.W., M.F.
 * Created:     17-July-96 
 *                                                                         
 * Description: Objects to handle arbitrary blocks
 *
 * Notes: 
 *
 * Modified:  
 *
 ***********************************************************HeaderEnd*********/

#ifndef _BLOCK_H
#define _BLOCK_H

#include <assert.h>

#include "basic/types.h"
#include "image/image.h"
#include "motion/motion.h"


/***********************************************************CommentBegin******
 *
 * -- Block -- Block Description Type
 *
 * Author:      M.F., T.W.
 *
 * Created:     17-July-96
 *
 * Description: Short  x0   upper left block corner: row (x) position
 *              Short  y0   upper left block corner: column (y) position
 *              Short  w    block width
 *              Short  h    block height
 *
 *              ! Attention:   The image data is  n o t  copied !
 * Note:        arbitrary block size is possible
 *
 * See also:    -
 *
 * Modified:    -
 *
 *****************************************************************************/
typedef struct {
  Short x0;
  Short y0;   
  Short w;    
  Short h;    
} Block;
/***********************************************************CommentEnd********/


/** prototypes ***************************************************************/

#include "block/proto/block.p"
#include "block/proto/blockMC.p"
#include "block/proto/imageblock.p"

#endif /* _BLOCK_H */
