#ifndef _DEFS_H_
#define _DEFS_H_



/* Picture coding types */
#define PICTURE_CODING_TYPE_INTRA    0
#define PICTURE_CODING_TYPE_INTER    1


/* H.263 coding modes */
#define BASELINE_MODE                0
#define UMV_MODE                     1
#define AP_MODE                      2
#define UMV_AP_MODE                  3
#define PB_MODE                      4
#define SAC_MODE                     8


/* MB coding modes for H.263 and other coders */
#define MODE_UNSET                  -2
#define MODE_UNCODED                -1
#define MODE_INTER                   0
#define MODE_INTER_Q                 1
#define MODE_INTER4V                 2
#define MODE_INTRA                   3
#define MODE_INTRA_Q                 4
#define MODE_STUFFING                5

/* Pyramid scales */
#define SCALE_STEP            4
#define SCALE_MIN            16
#define SCALE_MAX           140


/* from types.h */
/**************************************/
/**** GENERAL TYPE DEFINITIONS *******/
/**************************************/
#define Const const
typedef void                 Void       ;

typedef char                 Char       ;
typedef const    char        C_Char     ;

typedef unsigned char        Byte       ;
typedef Const    Byte        C_Byte     ;
typedef unsigned char        UChar      ;
typedef Const    UChar       C_UChar    ;

typedef short    int         Short      ;
typedef short    int         SInt       ;
typedef unsigned short       UShort     ;
typedef unsigned short       USInt      ;
typedef Const    short       C_Short    ;
typedef Const    short       C_SInt     ;
typedef Const    UShort      C_UShort   ;
typedef Const    UShort      C_USInt    ;

typedef          int         Int        ;
typedef Const    int         C_Int      ;

typedef unsigned int         UInt       ;
typedef Const    UInt        C_UInt     ;

typedef long     int         Long       ;
typedef Const    long        C_Long     ;

typedef unsigned long int    ULong      ;
typedef Const    ULong       C_ULong    ;

typedef float                Float      ;
typedef Const    float       C_Float    ;

typedef double               Double     ;
typedef Const    double      C_Double   ;

typedef FILE                 File       ;


#endif  /* #ifndef _DEFS_H_ */
