/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        h263codec.h
 *
 * Author:      T.W.
 *
 * Created:	12-Nov-96
 *                                                                         
 * Description: Header file for h263codec.c
 *
 * Notes: 	
 *
 * Modified:	
 *              
 *
 ***********************************************************HeaderEnd*********/


#ifndef   _H263CODEC_H_
#define   _H263CODEC_H_

#include "basic.h"
#include "block.h"
#include "motion.h"
#include "dct.h"
#include "bitio.h"

#define NUMBER_OF_LEVELS 64
#define SQCIF 1
#define QCIF  2
#define CIF   3
#define CIF4  4
#define CIF16 5

#define MACROBLOCK_SIZE                                          16 
#define BLOCK_SIZE                                                8 
#define MAX_SEARCH_RANGE                                         32

#define PICTURE_CODING_TYPE_INTRA                                 0
#define PICTURE_CODING_TYPE_INTER                                 1



typedef struct {
  Int intradc;     /* DC coefficient for I-macroblocks */
  Int *level;      /* (DCT) transform coefficients */
} H263blkStruct;


typedef struct {
  Int type;        /* MB type: MODE_UNCODED, MODE_INTER, MODE_INTER_Q, ... */
  Int quant;       /* MB quantizer */
  Int *cbp;        /* Coded block pattern for all blocks in MB */
  MVector **pv;    /* Predicted motion vector */
  MVector **mv;    /* Motion vector */
  H263blkStruct **blk;    /* Blocks */
  /* Additional, useful variables */
  Int rate;        /* Rate */
  Int dist;        /* Distortion */
} H263mbStruct;


typedef struct {
  Int gbscPresent;  /* GOB sync present ? */
  Int gn;
  Int gquant;       /* GOB quantizer */
  Int gsbi;
  Int gfid;
} H263gobStruct;    /* Group Of Blocks structure */


typedef struct {
  Int currentQuant;            /* Current quantizer */
  Int tr;
  Int ptype;
  Int pquant;
  Int cpm;
  Int psbi;
  Int trb;
  Int dbquant;
  Int previousPTYPE;
  Int previousGFID;
  Int splitScreenIndicator;    /* PTYPE Bit 3   */
  Int documentCameraIndicator; /* PTYPE Bit 4   */
  Int freezePictureRelease;    /* PTYPE Bit 5   */
  Int sourceFormat;            /* PTYPE Bit 6-8 */
  Int pictureCodingType;       /* PTYPE Bit 9   */
  Int umv;                     /* PTYPE Bit 10  */
  Int sac;                     /* PTYPE Bit 11  */
  Int ap;                      /* PTYPE Bit 12  */
  Int pb;                      /* PTYPE Bit 13  */
  Int memory;
  Int widthFrame;              /* Horizontal Image dimension */
  Int heightFrame;             /* Vertical Image dimension */
  Int numberOfGOBs;            /* in one image */
  Int numberOfMBs;             /* in one GOB */
  Int numberOfBLKs;            /* in one macroblock */
  Int numberOfMVs;             /* in one macroblock */
  H263gobStruct **gob;
  H263mbStruct **mb;
} H263picStruct;


typedef struct {
  Int modeUncoded;
  Int modeInter;
  Int modeInterQ;
  Int modeInter4v;
  Int modeIntra;
  Int modeIntraQ;
  Int coeffL;
  Int coeffC;
  Int vectorX;
  Int vectorY;
  Int vectorT;
  Int cbpy;   
  Int mcbpc;  
  Int modb;   
  Int cbpb;   
  Int cod;    
  Int dquant; 
  Int header;  
  Int pstuff;
  Int total;
} H263bitsCountStruct;


#include "h263codec/proto/h263structs.p"
#include "h263codec/proto/h263quant.p"
#include "h263codec/proto/h263count.p"
#include "h263codec/proto/h263InitTables.p"
#include "h263codec/proto/h263LoadTables.p"
#include "h263codec/proto/h263MC.p"
#include "h263codec/proto/h263MVPred.p" 
#include "h263codec/proto/h263codec.p"

#include "h263demux/h263demux.h"

#endif /* _H263CODEC_H_ */
