#include "global.h"


int H263parseCbpyI(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 6, &val);
  switch (val & 0xfff0) {
  case 0x30: ConsumeBitsX(bs, 2); return(15);
  }
  switch (val & 0xfffc) {
  case 0xc: ConsumeBitsX(bs, 4); return(0);
  case 0x24: ConsumeBitsX(bs, 4); return(3);
  case 0x1c: ConsumeBitsX(bs, 4); return(5);
  case 0x2c: ConsumeBitsX(bs, 4); return(7);
  case 0x14: ConsumeBitsX(bs, 4); return(10);
  case 0x28: ConsumeBitsX(bs, 4); return(11);
  case 0x10: ConsumeBitsX(bs, 4); return(12);
  case 0x20: ConsumeBitsX(bs, 4); return(13);
  case 0x18: ConsumeBitsX(bs, 4); return(14);
  }
  switch (val & 0xfffe) {
  case 0xa: ConsumeBitsX(bs, 5); return(1);
  case 0x8: ConsumeBitsX(bs, 5); return(2);
  case 0x6: ConsumeBitsX(bs, 5); return(4);
  case 0x4: ConsumeBitsX(bs, 5); return(8);
  }
  switch (val & 0xffff) {
  case 0x2: ConsumeBitsX(bs, 6); return(6);
  case 0x3: ConsumeBitsX(bs, 6); return(9);
  }
  fprintf(stderr, "SyntaxError in H263parseCbpyI");
  return(-1);
}
int H263parseMcbpcI(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 9, &val);
  switch (val & 0xff00) {
  case 0x100: ConsumeBitsX(bs, 1); return(0);
  }
  switch (val & 0xffc0) {
  case 0x40: ConsumeBitsX(bs, 3); return(1);
  case 0x80: ConsumeBitsX(bs, 3); return(2);
  case 0xc0: ConsumeBitsX(bs, 3); return(3);
  }
  switch (val & 0xffe0) {
  case 0x20: ConsumeBitsX(bs, 4); return(4);
  }
  switch (val & 0xfff8) {
  case 0x8: ConsumeBitsX(bs, 6); return(5);
  case 0x10: ConsumeBitsX(bs, 6); return(6);
  case 0x18: ConsumeBitsX(bs, 6); return(7);
  }
  switch (val & 0xffff) {
  case 0x1: ConsumeBitsX(bs, 9); return(8);
  }
  fprintf(stderr, "SyntaxError in H263parseMcbpcI");
  return(-1);
}
int H263parseMcbpcP(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 9, &val);
  switch (val & 0xff00) {
  case 0x100: ConsumeBitsX(bs, 1); return(0);
  }
  switch (val & 0xffc0) {
  case 0xc0: ConsumeBitsX(bs, 3); return(4);
  case 0x80: ConsumeBitsX(bs, 3); return(8);
  }
  switch (val & 0xffe0) {
  case 0x60: ConsumeBitsX(bs, 4); return(1);
  case 0x40: ConsumeBitsX(bs, 4); return(2);
  }
  switch (val & 0xfff0) {
  case 0x30: ConsumeBitsX(bs, 5); return(12);
  }
  switch (val & 0xfff8) {
  case 0x28: ConsumeBitsX(bs, 6); return(3);
  case 0x20: ConsumeBitsX(bs, 6); return(16);
  }
  switch (val & 0xfffc) {
  case 0x1c: ConsumeBitsX(bs, 7); return(5);
  case 0x18: ConsumeBitsX(bs, 7); return(6);
  case 0x14: ConsumeBitsX(bs, 7); return(9);
  case 0x10: ConsumeBitsX(bs, 7); return(10);
  case 0xc: ConsumeBitsX(bs, 7); return(15);
  }
  switch (val & 0xfffe) {
  case 0xa: ConsumeBitsX(bs, 8); return(11);
  case 0x8: ConsumeBitsX(bs, 8); return(13);
  case 0x6: ConsumeBitsX(bs, 8); return(14);
  }
  switch (val & 0xffff) {
  case 0x5: ConsumeBitsX(bs, 9); return(7);
  case 0x4: ConsumeBitsX(bs, 9); return(17);
  case 0x3: ConsumeBitsX(bs, 9); return(18);
  case 0x2: ConsumeBitsX(bs, 9); return(19);
  case 0x1: ConsumeBitsX(bs, 9); return(20);
  }
  fprintf(stderr, "SyntaxError in H263parseMcbpcP");
  return(-1);
}
int H263parseModb(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 2, &val);
  switch (val & 0xfffe) {
  case 0x0: ConsumeBitsX(bs, 1); return(0);
  }
  switch (val & 0xffff) {
  case 0x2: ConsumeBitsX(bs, 2); return(1);
  case 0x3: ConsumeBitsX(bs, 2); return(2);
  }
  fprintf(stderr, "SyntaxError in H263parseModb");
  return(-1);
}
int H263parseMvd(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 13, &val);
  switch (val & 0xf000) {
  case 0x1000: ConsumeBitsX(bs, 1); return(32);
  }
  switch (val & 0xfc00) {
  case 0xc00: ConsumeBitsX(bs, 3); return(31);
  case 0x800: ConsumeBitsX(bs, 3); return(33);
  }
  switch (val & 0xfe00) {
  case 0x600: ConsumeBitsX(bs, 4); return(30);
  case 0x400: ConsumeBitsX(bs, 4); return(34);
  }
  switch (val & 0xff00) {
  case 0x300: ConsumeBitsX(bs, 5); return(29);
  case 0x200: ConsumeBitsX(bs, 5); return(35);
  }
  switch (val & 0xffc0) {
  case 0x1c0: ConsumeBitsX(bs, 7); return(28);
  case 0x180: ConsumeBitsX(bs, 7); return(36);
  }
  switch (val & 0xffe0) {
  case 0xe0: ConsumeBitsX(bs, 8); return(25);
  case 0x120: ConsumeBitsX(bs, 8); return(26);
  case 0x160: ConsumeBitsX(bs, 8); return(27);
  case 0x140: ConsumeBitsX(bs, 8); return(37);
  case 0x100: ConsumeBitsX(bs, 8); return(38);
  case 0xc0: ConsumeBitsX(bs, 8); return(39);
  }
  switch (val & 0xfff8) {
  case 0x98: ConsumeBitsX(bs, 10); return(22);
  case 0xa8: ConsumeBitsX(bs, 10); return(23);
  case 0xb8: ConsumeBitsX(bs, 10); return(24);
  case 0xb0: ConsumeBitsX(bs, 10); return(40);
  case 0xa0: ConsumeBitsX(bs, 10); return(41);
  case 0x90: ConsumeBitsX(bs, 10); return(42);
  }
  switch (val & 0xfffc) {
  case 0x24: ConsumeBitsX(bs, 11); return(8);
  case 0x2c: ConsumeBitsX(bs, 11); return(9);
  case 0x34: ConsumeBitsX(bs, 11); return(10);
  case 0x3c: ConsumeBitsX(bs, 11); return(11);
  case 0x44: ConsumeBitsX(bs, 11); return(12);
  case 0x4c: ConsumeBitsX(bs, 11); return(13);
  case 0x54: ConsumeBitsX(bs, 11); return(14);
  case 0x5c: ConsumeBitsX(bs, 11); return(15);
  case 0x64: ConsumeBitsX(bs, 11); return(16);
  case 0x6c: ConsumeBitsX(bs, 11); return(17);
  case 0x74: ConsumeBitsX(bs, 11); return(18);
  case 0x7c: ConsumeBitsX(bs, 11); return(19);
  case 0x84: ConsumeBitsX(bs, 11); return(20);
  case 0x8c: ConsumeBitsX(bs, 11); return(21);
  case 0x88: ConsumeBitsX(bs, 11); return(43);
  case 0x80: ConsumeBitsX(bs, 11); return(44);
  case 0x78: ConsumeBitsX(bs, 11); return(45);
  case 0x70: ConsumeBitsX(bs, 11); return(46);
  case 0x68: ConsumeBitsX(bs, 11); return(47);
  case 0x60: ConsumeBitsX(bs, 11); return(48);
  case 0x58: ConsumeBitsX(bs, 11); return(49);
  case 0x50: ConsumeBitsX(bs, 11); return(50);
  case 0x48: ConsumeBitsX(bs, 11); return(51);
  case 0x40: ConsumeBitsX(bs, 11); return(52);
  case 0x38: ConsumeBitsX(bs, 11); return(53);
  case 0x30: ConsumeBitsX(bs, 11); return(54);
  case 0x28: ConsumeBitsX(bs, 11); return(55);
  case 0x20: ConsumeBitsX(bs, 11); return(56);
  }
  switch (val & 0xfffe) {
  case 0xa: ConsumeBitsX(bs, 12); return(2);
  case 0xe: ConsumeBitsX(bs, 12); return(3);
  case 0x12: ConsumeBitsX(bs, 12); return(4);
  case 0x16: ConsumeBitsX(bs, 12); return(5);
  case 0x1a: ConsumeBitsX(bs, 12); return(6);
  case 0x1e: ConsumeBitsX(bs, 12); return(7);
  case 0x1c: ConsumeBitsX(bs, 12); return(57);
  case 0x18: ConsumeBitsX(bs, 12); return(58);
  case 0x14: ConsumeBitsX(bs, 12); return(59);
  case 0x10: ConsumeBitsX(bs, 12); return(60);
  case 0xc: ConsumeBitsX(bs, 12); return(61);
  case 0x8: ConsumeBitsX(bs, 12); return(62);
  }
  switch (val & 0xffff) {
  case 0x5: ConsumeBitsX(bs, 13); return(0);
  case 0x7: ConsumeBitsX(bs, 13); return(1);
  case 0x6: ConsumeBitsX(bs, 13); return(63);
  }
  fprintf(stderr, "SyntaxError in H263parseMvd");
  return(-1);
}
int H263parseTcoef(Bitstr *bs) {
  int val;

  ShowBitsX(bs, 0, 12, &val);
  switch (val & 0xfc00) {
  case 0x800: ConsumeBitsX(bs, 2); return(0);
  }
  switch (val & 0xfe00) {
  case 0xc00: ConsumeBitsX(bs, 3); return(12);
  }
  switch (val & 0xff00) {
  case 0xf00: ConsumeBitsX(bs, 4); return(1);
  case 0xe00: ConsumeBitsX(bs, 4); return(18);
  case 0x700: ConsumeBitsX(bs, 4); return(58);
  }
  switch (val & 0xff80) {
  case 0x680: ConsumeBitsX(bs, 5); return(22);
  case 0x600: ConsumeBitsX(bs, 5); return(25);
  case 0x580: ConsumeBitsX(bs, 5); return(28);
  }
  switch (val & 0xffc0) {
  case 0x540: ConsumeBitsX(bs, 6); return(2);
  case 0x500: ConsumeBitsX(bs, 6); return(13);
  case 0x4c0: ConsumeBitsX(bs, 6); return(31);
  case 0x480: ConsumeBitsX(bs, 6); return(34);
  case 0x440: ConsumeBitsX(bs, 6); return(36);
  case 0x400: ConsumeBitsX(bs, 6); return(38);
  case 0x3c0: ConsumeBitsX(bs, 6); return(61);
  case 0x380: ConsumeBitsX(bs, 6); return(63);
  case 0x340: ConsumeBitsX(bs, 6); return(64);
  case 0x300: ConsumeBitsX(bs, 6); return(65);
  }
  switch (val & 0xffe0) {
  case 0x2e0: ConsumeBitsX(bs, 7); return(3);
  case 0x2c0: ConsumeBitsX(bs, 7); return(40);
  case 0x2a0: ConsumeBitsX(bs, 7); return(42);
  case 0x280: ConsumeBitsX(bs, 7); return(43);
  case 0x260: ConsumeBitsX(bs, 7); return(66);
  case 0x240: ConsumeBitsX(bs, 7); return(67);
  case 0x220: ConsumeBitsX(bs, 7); return(68);
  case 0x200: ConsumeBitsX(bs, 7); return(69);
  case 0x60: ConsumeBitsX(bs, 7); return(102);
  }
  switch (val & 0xfff0) {
  case 0x1f0: ConsumeBitsX(bs, 8); return(4);
  case 0x1e0: ConsumeBitsX(bs, 8); return(14);
  case 0x1d0: ConsumeBitsX(bs, 8); return(19);
  case 0x1c0: ConsumeBitsX(bs, 8); return(44);
  case 0x1b0: ConsumeBitsX(bs, 8); return(45);
  case 0x1a0: ConsumeBitsX(bs, 8); return(70);
  case 0x190: ConsumeBitsX(bs, 8); return(71);
  case 0x180: ConsumeBitsX(bs, 8); return(72);
  case 0x170: ConsumeBitsX(bs, 8); return(73);
  case 0x160: ConsumeBitsX(bs, 8); return(74);
  case 0x150: ConsumeBitsX(bs, 8); return(75);
  case 0x140: ConsumeBitsX(bs, 8); return(76);
  case 0x130: ConsumeBitsX(bs, 8); return(77);
  }
  switch (val & 0xfff8) {
  case 0x128: ConsumeBitsX(bs, 9); return(5);
  case 0x120: ConsumeBitsX(bs, 9); return(6);
  case 0x118: ConsumeBitsX(bs, 9); return(23);
  case 0x110: ConsumeBitsX(bs, 9); return(26);
  case 0x108: ConsumeBitsX(bs, 9); return(46);
  case 0x100: ConsumeBitsX(bs, 9); return(47);
  case 0xf8: ConsumeBitsX(bs, 9); return(48);
  case 0xf0: ConsumeBitsX(bs, 9); return(49);
  case 0xe8: ConsumeBitsX(bs, 9); return(50);
  case 0xe0: ConsumeBitsX(bs, 9); return(51);
  case 0xd8: ConsumeBitsX(bs, 9); return(52);
  case 0xd0: ConsumeBitsX(bs, 9); return(53);
  case 0xc8: ConsumeBitsX(bs, 9); return(59);
  case 0xc0: ConsumeBitsX(bs, 9); return(78);
  case 0xb8: ConsumeBitsX(bs, 9); return(79);
  case 0xb0: ConsumeBitsX(bs, 9); return(80);
  case 0xa8: ConsumeBitsX(bs, 9); return(81);
  case 0xa0: ConsumeBitsX(bs, 9); return(82);
  case 0x98: ConsumeBitsX(bs, 9); return(83);
  case 0x90: ConsumeBitsX(bs, 9); return(84);
  case 0x88: ConsumeBitsX(bs, 9); return(85);
  }
  switch (val & 0xfffc) {
  case 0x84: ConsumeBitsX(bs, 10); return(7);
  case 0x80: ConsumeBitsX(bs, 10); return(8);
  case 0x3c: ConsumeBitsX(bs, 10); return(15);
  case 0x38: ConsumeBitsX(bs, 10); return(20);
  case 0x34: ConsumeBitsX(bs, 10); return(24);
  case 0x30: ConsumeBitsX(bs, 10); return(29);
  case 0x2c: ConsumeBitsX(bs, 10); return(32);
  case 0x28: ConsumeBitsX(bs, 10); return(35);
  case 0x24: ConsumeBitsX(bs, 10); return(37);
  case 0x20: ConsumeBitsX(bs, 10); return(39);
  case 0x1c: ConsumeBitsX(bs, 10); return(86);
  case 0x18: ConsumeBitsX(bs, 10); return(87);
  case 0x14: ConsumeBitsX(bs, 10); return(88);
  case 0x10: ConsumeBitsX(bs, 10); return(89);
  }
  switch (val & 0xfffe) {
  case 0xe: ConsumeBitsX(bs, 11); return(9);
  case 0xc: ConsumeBitsX(bs, 11); return(10);
  case 0x40: ConsumeBitsX(bs, 11); return(11);
  case 0x42: ConsumeBitsX(bs, 11); return(16);
  case 0x44: ConsumeBitsX(bs, 11); return(54);
  case 0x46: ConsumeBitsX(bs, 11); return(55);
  case 0xa: ConsumeBitsX(bs, 11); return(60);
  case 0x8: ConsumeBitsX(bs, 11); return(62);
  case 0x48: ConsumeBitsX(bs, 11); return(90);
  case 0x4a: ConsumeBitsX(bs, 11); return(91);
  case 0x4c: ConsumeBitsX(bs, 11); return(92);
  case 0x4e: ConsumeBitsX(bs, 11); return(93);
  }
  switch (val & 0xffff) {
  case 0x50: ConsumeBitsX(bs, 12); return(17);
  case 0x51: ConsumeBitsX(bs, 12); return(21);
  case 0x52: ConsumeBitsX(bs, 12); return(27);
  case 0x53: ConsumeBitsX(bs, 12); return(30);
  case 0x54: ConsumeBitsX(bs, 12); return(33);
  case 0x55: ConsumeBitsX(bs, 12); return(41);
  case 0x56: ConsumeBitsX(bs, 12); return(56);
  case 0x57: ConsumeBitsX(bs, 12); return(57);
  case 0x58: ConsumeBitsX(bs, 12); return(94);
  case 0x59: ConsumeBitsX(bs, 12); return(95);
  case 0x5a: ConsumeBitsX(bs, 12); return(96);
  case 0x5b: ConsumeBitsX(bs, 12); return(97);
  case 0x5c: ConsumeBitsX(bs, 12); return(98);
  case 0x5d: ConsumeBitsX(bs, 12); return(99);
  case 0x5e: ConsumeBitsX(bs, 12); return(100);
  case 0x5f: ConsumeBitsX(bs, 12); return(101);
  }
  fprintf(stderr, "SyntaxError in H263parseTcoef");
  return(-1);
}
