/************************************************************************
 *
 *  quant.c, part of tmn (TMN encoder)
 *  Copyright (C) 1995, 1996  Telenor R&D, Norway
 *        Karl Olav Lillevold <Karl.Lillevold@nta.no>
 *  
 *  Contacts: 
 *  Karl Olav Lillevold               <Karl.Lillevold@nta.no>, or
 *  Robert Danielsen                  <Robert.Danielsen@nta.no>
 *
 *  Telenor Research and Development  http://www.nta.no/brukere/DVC/
 *  P.O.Box 83                        tel.:   +47 63 84 84 00
 *  N-2007 Kjeller, Norway            fax.:   +47 63 81 00 76
 *  
 ************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	quantH263.c
 *
 * Author:      Karl Olav Lillevold
 *
 * Created:	unknown
 *                                                                         
 * Description: H.263-based qunatization
 *
 ***********************************************************HeaderEnd*********/

#include "global.h"

/***********************************************************CommentBegin******
 ****************************************************************************
 *
 * -- H263dequant -- H.263-based de-quantization
 *
 * Author :            Karl Olav Lillevold		
 *	
 * Purpose :           Quantization of DCT-transform coefficients		
 *	
 * Arguments in :      Int *qcoeff :   pointer to quantized coefficients.
 *                     Int mbQuant:    Quantization parameter of macroblock
 *                     Int mode   :    
 *                     Int cbp     :   coded block pattern
 *
 * Arguments in/out :  none
 *
 * Arguments out :     Int *coeff:     dequantized coefficients.
 *
 * Return values :     none
 *	
 * Side effects :      none
 *	
 * Description :       De-Quantizes 'qcoeff' based on H.263 rules given the 
 *                     macroblock 'mode' and the quantization parameter 
 *	               'mbQuant'.
 *	
 * See also :          H263quant
 *	
 * Modified :        - T.W., 12-Nov-96, adapted from TMN-2.0
 *                     (Cross-checked to TMN-version: same output, overflow
 *                      observed in both versions--clipping necessary )
 *                   - K.S., 15-May-97, introduced 'cbp'-check.
 *
 ****************************************************************************/
Void H263dequant(Int *qcoeff, Int intradc, Int mbQuant, Int mode, Int cbp,
		 Int *coeff)
/***********************************************************CommentEnd********/
{
  Int i;


  if (cbp) {
    if (mbQuant>0) {
      if (mode == MODE_INTRA || mode == MODE_INTRA_Q) { /* Intra */
	coeff[0] = intradc;
	for (i=1;i<64;i++) {
	  if (qcoeff[i-1]!=0) {
	    if ((mbQuant % 2) == 1) {
	      coeff[i] = mbQuant * (2*ABS(qcoeff[i-1]) + 1);
	    } else {
	      coeff[i] = mbQuant * (2*ABS(qcoeff[i-1]) + 1) - 1;
	    }
	    coeff[i] = SIGN(qcoeff[i-1]) * coeff[i];
	  } else { 
	    coeff[i] = 0;
	  }
	}
      } else { /* Inter */
	for (i=0;i<64;i++) {
	  if (qcoeff[i]!=0) {
	    if ((mbQuant % 2) == 1) {
	      coeff[i] = mbQuant * (2*ABS(qcoeff[i]) + 1);
	    } else {
	      coeff[i] = mbQuant * (2*ABS(qcoeff[i]) + 1) - 1;
	    }
	    coeff[i] = SIGN(qcoeff[i]) * coeff[i];
	  } else { 
	    coeff[i] = 0;
	  }
	}
      }
    } else {
      /* No quantization */
      for (i = 0; i < 64; i++) {
	coeff[i] = qcoeff[i];
      }
    }
  } else {     /* cbp == 0 */
    for (i = 0; i < 64; i++)
      coeff[i] = 0;
    if (mode == MODE_INTRA || mode == MODE_INTRA_Q)  /* Intra */
      coeff[0] = intradc;
  }
}



