/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	macros.h
 *
 * Author:	K.S., T.W.
 * Created:	13-Jun-96 
 *                                                                         
 * Description: Common macros of compression group in LNT
 *
 * Notes: 	
 *
 * Modified:	17-July-96 M.F.
 *
 ***********************************************************HeaderEnd*********/


#ifndef _MACROS_H
#define _MACROS_H

#include <malloc.h>
#include <string.h>

#ifndef MAX
/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MAX -- Macro: maximum of two values
 *
 * Arguments in:  a, b
 *
 * Return values: maximum of a, b
 *
 * Example:       c = MAX(a,b);
 *****************************************************************************/
#define MAX(a,b)              (((a) > (b)) ? (a) : (b))
/***********************************************************CommentEnd********/
#endif

#ifndef MIN
/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MIN -- Macro: minimum of two values
 *
 * Arguments in:  a, b
 *
 * Return values: minimum of a, b
 *
 * Example:       c = MIN(a,b);
 *****************************************************************************/
#define MIN(a,b)              (((a) < (b)) ? (a) : (b))
/***********************************************************CommentEnd********/
#endif

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- CLIP -- Macro: clip 'a' to range i <= a <= s
 *
 * Arguments in:  a, i, s
 *
 * Return values: a is clipped to the range i <= a <= s
 *
 * Example:       a = CLIP(a,0,255);
 *****************************************************************************/
#define CLIP(a,i,s)            (((a) > (s)) ? (s) : MAX(a,i))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- CLIPBYTE -- Macro: clip 'a' to range of a byte 0 <= a <= 255
 *
 * Arguments in:  a
 *
 * Return values: a is clipped to the range 0 <= a <= 255
 *
 * Example:       a = CLIPBYTE(a);
 *****************************************************************************/
#define CLIPBYTE(a)            (((a) > 255) ? 255 : MAX(a,0))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MIRROR -- Macro: mirror a value 'a' at another 'm'
 *
 * Arguments in:  a, m
 *
 * Return values: a is mirrored at m
 *
 * Example:       a = MIRROR(a,m);
 *****************************************************************************/
#define MIRROR(a,m)            (2*(m)-(a))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- WRAP -- Macro: wrap 'a' at the nearest interval border if it is outside
 *
 * Arguments in:  a, l, u
 *
 * Return values: 'a' is mirrored at the nearest border of the interval
 *                [l - 0.5 , u + 0.5] if it is not inside this interval
 *                (with integer arithmetic).
 *                For example:    l = 7; u = 12;
 *                       *  a = 5;   ==>   a -> 8
 *                       *  a = 9;   ==>   a -> 9
 *                       *  a = 20;  ==>   a -> 5
 *
 * Example:       a = WRAP(a,l,u);
 *****************************************************************************/
#define WRAP(a,l,u)         ((a)<(l)?MIRROR(a+1,l):((a)>(u)?MIRROR(a-1,u):(a)))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- INT -- Macro: convert to Int
 *
 * Arguments in:   a
 *
 * Return values:
 *
 * Example:        b = INT(a);
 *****************************************************************************/
#define INT(a)                 ((Int) (floor((Double) a)))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MNINT -- Macro: convert to Int with symmetric offset
 *
 * Arguments in:   a
 *
 * Return values: 
 *****************************************************************************/
#define MNINT(a)    	       ((a) < 0 ? (int)(a - 0.5) : (int)(a + 0.5))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MFLOOR -- Macro: convert to Int with asymetric offset
 *
 * Arguments in:   a
 *
 * Return values: 
 *****************************************************************************/
#define MFLOOR(a)              ((a) < 0 ? (int)(a - 0.5) : (int)(a))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MAX3 -- Macro: maximum of three values
 *
 * Arguments in:   x, y, z
 *
 * Return values:  maximum of x, y, z
 *
 * Example:        a = MAX3(x,y,z);
 *****************************************************************************/
#define MAX3(x,y,z)            MAX(MAX(x,y),z)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MIN3 -- Macro: minimum of three values
 *
 * Arguments in:   x, y, z
 *
 * Return values:  minimum of x, y, z
 *
 * Example:        a = MIN3(x,y,z);
 *****************************************************************************/
#define MIN3(x,y,z)            MIN(MIN(x,y),z)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- MEDIAN -- Macro: median of three values
 *
 * Arguments in:   x, y, z
 *
 * Return values:  median of x, y, z
 *
 * Example:        med = MEDIAN(x,y,z);
 *****************************************************************************/
#define MEDIAN(x,y,z)          ((x)+(y)+(z)-MAX3(x,y,z)-MIN3(x,y,z))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ROUND -- Macro: round a to nearest int
 *
 * Arguments in:    a
 *
 * Return values:   a rounded to int
 *
 * Example:         i = ROUND(a);
 *****************************************************************************/
#define ROUND(a)	((a)>0 ? (int)(a+0.5) : -(int)(0.5-a))		
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- FLOOR -- Macro: truncate a to nearest ABS(int) < ABS(a)
 *
 * Arguments in:    a
 *
 * Return values:   next integer with abs(i) < abs(a)
 *
 * Example:         i = FLOOR(a);
 *****************************************************************************/
#define FLOOR(a)	((a)>0 ? (int)(a) : -(int)(-a))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- CEILING -- Macro: round a up to nearest ABS(int) > ABS(a)
 *
 * Arguments in:    a
 *
 * Return values:   a rounded up to int
 *
 * Example:         i = CEILING(a);
 *****************************************************************************/
#define CEILING(a) ((a)==(int)(a) ? (a) : (a)>0 ? 1+(int)(a) : -(1+(int)(-a)))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- SQUARE -- Macro: square of a value
 *
 * Arguments in:   a
 *
 * Return values:
 *****************************************************************************/
#define SQUARE(a)             ((a)*(a))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- CUBE -- Macro: cube of a value
 *
 * Arguments in:   a
 *
 * Return values:
 *****************************************************************************/
#define CUBE(a)               ((a)*(a)*(a))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- LD -- Macro: logarithmus dualis (ld)
 *
 * Arguments in:   a
 *
 * Return values:  ld(a)
 *****************************************************************************/
#define LD(a)                 (log(a)/log(2))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ABS -- Macro: absolut of a value
 *
 * Arguments in:   a
 *
 * Return values:
 *****************************************************************************/
#define ABS(x)                (((x) < 0) ? -(x) : (x))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ZSIGN -- Macro: symetric signum of a value
 *
 * Arguments in:    a
 *
 * Return values:  -1 if a < 0; 0 if a = 0; +1 if a > 0
 *****************************************************************************/
#define ZSIGN(a)       	      (((a)<0) ? -1 : (a)>0 ? 1 : 0)	
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- SIGN -- Macro: asymetric signum of a value
 *
 * Arguments in:    a
 *
 * Return values:   -1 if a < 0; +1 if a >= 0
 *****************************************************************************/
#define SIGN(x)               (((x) < 0) ? -1 : 1)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- EVEN -- Macro: check value for even
 *
 * Arguments in:   a
 *
 * Return values:  1 if a is even
 *****************************************************************************/
#define EVEN(a)               ((a) % 2) == 0)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ODD -- Macro: check value for odd
 *
 * Arguments in:   a
 *
 * Return values:  1 if a is odd
 *****************************************************************************/
#define ODD(a)                ((a) % 2) == 1)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- STRLEN -- Macro: determine length of string
 *
 * Arguments in:   P_string
 *
 * Return values:  if P_string strlen() else -1
 *****************************************************************************/
#define STRLEN(P_string)      ((P_string==NULL) ? strlen(P_string) : -1)
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- TYPE_MALLOC -- Macro: allocates memory for specific type and size
 *
 * Arguments in:  type, size
 *
 * Return values: type *
 *****************************************************************************/
#define TYPE_MALLOC(type,nb)  ((type *) malloc(sizeof(type)*(nb)))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- TYPE_CALLOC -- Macro: allocates and inits memory for spec. type and size
 *
 * Arguments in:  type, size
 *
 * Return values: type *
 *****************************************************************************/
#define TYPE_CALLOC(type,nb)  ((type *) calloc((nb), sizeof(type)))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- NEW -- Macro: allocates memory for specific type
 *
 * Arguments in:   type
 *
 * Return values:  type *
 *****************************************************************************/
#define NEW(type)             ((type *) malloc(sizeof(type)   ))
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- ASSERT -- Macro: asserts that condition 'cond' is true.
 *
 * Arguments in:   cond    (condition)
 *
 * Return values:  -
 *****************************************************************************/
#ifndef ASSERT
#define ASSERT(cond)          (!(cond) ? \
			       fprintf(stderr,"ASSERT failed in File '%s', "\
				        "Line %d\n", __FILE__, __LINE__) \
                                 : 0)
#endif
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *****************************************************************************
 *
 * -- Values -- Predefined Values
 *
 *****************************************************************************/
/* Constants */
#define PI                    3.14159265358979323846

#define NO_INDEX  -1

/* Switches */
#define OFF                                                                 0
#define ON                                                             !(OFF)

#ifdef FALSE
#undef FALSE
#endif
#define FALSE                                                               0

#ifdef TRUE
#undef TRUE
#endif
#define TRUE                                                         (!FALSE)

/* FILE TYPE DEFINITIONS */
#define	SEP_RAW_FILES 0          /* separated raw files */
#define CAT_SEQ_FILE  1          /* whole sequence in one file concatenated */
#define KHOROS_FILES  2          /* khoros (version 1) file format */

#define INFO_LINE_MAX 2048       /* Maximal line length in info file */
/***********************************************************CommentEnd********/

#endif /* _MACROS_H */               




