/*
 * main.c - 
 *
 * 15.10.97, jw.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "dispconf.h"	/* Options initializers */
#include "config.h"	/* Options initializers */

#include "global.h"	/* all prototypes */


#ifdef DEBUG
FILE *debugfp = stderr;
char *debugfilename = NULL;
#endif

static OptionsStruct Init_Options =
{
  NULL,
  USE_VIS,
  USE_DGA,
  USE_SHM,
  DISPLAY,
  0,		/* Default for cover_window: use own toplevel */
  THREAD_YUV,
  GRAY,
  PSEUDOCOLOR,
  EXPAND,
  SIZE_QCIF,
  0,		/* Default for fps */
  LOOP,
  AUDIO
};

OptionsStruct Options;

#if defined(__sun) && defined(FILE)
# define memmove(d, s, n) bcopy(s, d, n)
#endif

static void ExitWithUsage(char *msg, int ret)
{
#define O(txt, def, opt) fprintf(stderr, "  -%s. Default: -%s%s.\n", txt, def ? "" : "no", opt);
  fprintf(stderr, "Usage: %s [-[no]option ...] file.pyra\n", Options.argv0);
#ifndef WITHOUT_DGA
  O("dga        Use Direct Graphics Access", USE_DGA, "dga");
#endif
  O("windowid   Use given window as parent", 1, " own toplevel");
  O("nodisplay  Don't show the decoded frames", DISPLAY, "display");
  O("expand     Double the size of the image", EXPAND, "expand");
  O("gray       Show video in grayscale", GRAY, "gray");
  O("noaudio    Disable audio", AUDIO, "audio");
/*  O("loop       Repeat the input stream infinitly", LOOP, "loop"); */
  O("pseudo     Show video in PseudoColor (8Bit)", PSEUDOCOLOR, "pseudo (TrueColor)");
  O("qcif       Show image in QCIF size", 1, SIZE_QCIF ? "qcif" : "cif");
#ifndef WITHOUT_SHM
  O("noshm      Don't use shared memory", USE_SHM, "shm");
#endif
#ifndef WITHOUT_THREADS
  O("threads    Spawn a thread for color conversion", THREAD_YUV, "threads");
#endif
#ifndef WITHOUT_VIS
  O("vis        Use UltraSparc Visual Instruction Set", USE_VIS, "vis");
#endif
  O("fps        If set, use given framerate", 1, "nofps (unlimited)");
  if (msg)
    fprintf(stderr, "\nHmmm: %s\n", msg);
  exit(ret);
}

int main(int argc, char *argv[]) 
{
  FILE *fp;
  int i, gn, numberOfGOBs;
  int source_qcif = -1;
  Picture *p, *ref;
  Bitstr *b;

  Options = Init_Options; 	/* struct copy */
  Options.argv0 = *argv++;

  while(*argv && **argv == '-' && argv[0][1]) 
    {
      char *o = *argv++;
      int v = strncmp("no", o+1, 2) ? 1 : 0;

      o += v ? 1 : 3;
           if (!strcmp(o, "gray"))	Options.visgray = v;
      else if (!strcmp(o, "grey"))	Options.visgray = v;
      else if (!strcmp(o, "pseudo"))	Options.vis8 = v;
      else if (!strcmp(o, "vis"))	Options.use_vis = v;
      else if (!strcmp(o, "dga"))	Options.use_dga = v;
      else if (!strcmp(o, "shm"))	Options.use_shm = v;
      else if (!strcmp(o, "shmem"))	Options.use_shm = v;
      else if (!strcmp(o, "display"))	Options.display = v;
      else if (!strcmp(o, "thread"))	Options.thread_yuv = v;
      else if (!strcmp(o, "threads"))	Options.thread_yuv = v;
      else if (!strcmp(o, "expand"))	Options.visexpand = v;
      else if (!strcmp(o, "audio"))	Options.audio = v;
      else if (!strcmp(o, "qcif"))	Options.qcif = v;
      else if (!strcmp(o, "cif"))	Options.qcif = !v;
      else if (!strcmp(o, "fps"))	Options.fps = atoi(*argv++);
      else if (!strcmp(o, "window"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "windowid"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
      else if (!strcmp(o, "id"))	
        Options.cover_window = strtol(*argv++, NULL, 0);
/*    else if (!strcmp(o, "loop"))	Options.loop = v;	*/
      else 
        ExitWithUsage("Unknown commandline option.", 1);
    }

  if (!Options.fps)
    {
      if (Options.audio)
	fprintf(stderr, "Audio disabled, -fps missing.\n");
      Options.audio = 0;
    }

  if (!*argv)
    ExitWithUsage("Name of input file is missing.", 0);

  if (argv[0][0] == '-' && argv[0][1] == '\0')
    fp = stdin;
  else if (!(fp = fopen(*argv, "r")))
    fprintf(stderr, "%s: ", *argv),perror("fopen"),exit(0);
  
  b = AllocBitstr(1024);	/* min 1 GOP */
  b->fp = fp;
  CheckInBuffer(b);

  ShowBitsX(b, 35, 3, &i);
  switch (i)
    {
    case QCIF:
      source_qcif = 1;
      numberOfGOBs = 9;
      break;
    case CIF:
      source_qcif = 0;
      numberOfGOBs = 18;
      break;
    case SQCIF:
    case CIF4:
    case CIF16:
    default:
      fprintf(stderr, "unknown H263 sourceFormat: %d\n", i);
      exit(0);
    }

  ref = (Picture *)malloc(sizeof(Picture));
  ref->w = source_qcif ? QCIF_W : CIF_W;
  ref->h = source_qcif ? QCIF_H : CIF_H;
  ref->y = (Byte *)malloc(sizeof(Byte) * ref->w * ref->h);
  ref->u = (Byte *)malloc(sizeof(Byte) * ref->w/2 * ref->h/2);
  ref->v = (Byte *)malloc(sizeof(Byte) * ref->w/2 * ref->h/2);

  p = (Picture *)malloc(sizeof(Picture));
  p->w = source_qcif ? QCIF_W : CIF_W;
  p->h = source_qcif ? QCIF_H : CIF_H;
  p->y = (Byte *)malloc(sizeof(Byte) * p->w * p->h);
  p->u = (Byte *)malloc(sizeof(Byte) * p->w/2 * p->h/2);
  p->v = (Byte *)malloc(sizeof(Byte) * p->w/2 * p->h/2);

  /* wrong: init_display should obey -qcif -cif flags */
  init_display(p->w, p->h);

#ifdef TESTBILD
  {
    int x, y;
    for (y = 0; y < p->h; y++)
      {
	for (x = 0; x < p->w; x++)
	  {
	    p->y[p->w*y+x] = (x+y) & 0xff;
	    p->u[p->w/2*(y/2)+x/2] = x & 0xff;
	    p->v[p->w/2*(y/2)+x/2] = y & 0xff;
	  }
      }

    yuv2rgb(p); 
    sleep(3);
  }
#endif
  
  while (!feof(b->fp))
    {
      Picture *tmp;

      for (gn = 0; gn < numberOfGOBs; gn++)
	{
	  /* sync at start of buffer */
	  if (H263LookupAnotherSync(b) < 0)
	    {
	      fprintf(stderr, "need one more sync in buffer\n");
	      exit(0);
	    }
	  
	  /* have a complete gob in buffer */
	  H263ParseDecodeGOB(b, ref, p);
	  ByteAlign(b);

	  /* b->ind points to next sync */
	  if (H263LookupAnotherSync(b) < 0)
	    {
	      CheckInBufferN(b);
	    }
	}
      yuv2rgb(p); 

      tmp = p; 
      p = ref;
      ref = tmp;

    }

  fclose(b->fp);

  FreeBitstr(&b);

  free((char *)ref->y);
  free((char *)ref->u);
  free((char *)ref->v);
  free((char *)ref);

  free((char *)p->y);
  free((char *)p->u);
  free((char *)p->v);
  free((char *)p);
  exit_display();
  return 0;
}

