/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	motion_structs.h
 *
 * Author:	K.S.
 * Created:	8-July-96 
 *                                                                         
 * Description: Common data structures of compression group in LNT
 *
 * Notes: 	
 *
 * Modified:	
 *
 ***********************************************************HeaderEnd*********/


#ifndef _MOTION_STRUCTS_H_
#define _MOTION_STRUCTS_H_

#include "basic/basic.h"
#include "image/image.h"
#include "function/function.h"


/*****
*
*     motion structure for translational motion
*
*****/
/***********************************************************CommentBegin******
 *
 * -- MVector -- motion vector structure
 *
 * Author:             K.S.
 *
 * Created:            7-Aug-96
 *	
 * Purpose:            Structure for a motion vector with full- and subpel-
 *                     components and timeshift.
 * 
 * Modified:           -
 *
 *****************************************************************************/
typedef struct {
  Short x;     /* horizontal translation */
  Short y;     /* verticale translation */
  Short sx;    /* horizontal sub-pel translation to the right */
  Short sy;    /* verticale sub-pel translation downwards */
  Short sF;    /* sub-pel fraction, e.g. 2 for half-pel */
  Short t;     /* timeshift */
} MVector;
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *
 * -- CostMVector -- motion vector structure with additional cost information
 *
 * Author:             K.S.
 *
 * Created:            8-Aug-96
 *	
 * Purpose:            Structure for a motion vector with full- and subpel-
 *                     components and additional information about
 *                     distortion and rate.
 * 
 * Example:            The y-fullpel-component of the motion vector is
 *                     accessed by
 *                               CostMVector *cmv;
 *                               cmv->mv->y;
 *
 * Modified:           -
 *
 *****************************************************************************/
typedef struct {
  MVector *mv;   /* motion vector (s.a.) */
  Double  d;     /* distortion associated with the mv */
  Double  r;     /* rate associated with the mv */
  Double  j;
} CostMVector;
/***********************************************************CommentEnd********/


/*****
*
*     motion structure for parametric motion
*
*****/
/***********************************************************CommentBegin******
 *
 * -- MParameters -- motion parameters structure
 *
 * Author:             K.S.
 *
 * Created:            11-Oct-96
 *
 * Purpose:            Structure for motion parameters of order 12.
 *
 * Description:        The pels are displaced according to
 *                       d_x = cx[0] + cx[1]*x + cx[2]*y + cx[3]*xy +
 *                             cx[4]*x^2 + cx[5]*y^2
 *                       d_y = cy[0] + cy[1]*x + cy[2]*y + cy[3]*xy +
 *                             cy[4]*x^2 + cy[5]*y^2
 *
 *                     The order is 12.
 *                     The origin is the middle of the image. (integer div /2)
 *
 * Modified:           -
 *
 *****************************************************************************/
typedef struct {
  Double cx[6];            /* Parameters for x component */
  Double cy[6];            /* Parameters for y component */
} MParameters;
/***********************************************************CommentEnd********/


/*****
*
*     Basic and generic motion structure
*
*****/
/***********************************************************CommentBegin******
 *
 * -- MotionModel -- motion model indicator
 *
 * Author:             K.S.
 *
 * Created:            8-Aug-96
 *	
 * Purpose:            Enumeration of motion models
 * 
 * Modified:           -
 *
 *****************************************************************************/
typedef enum {
  TRANSLATION,          /* translational motion */
  PARAMETRIC            /* parametric motion model */
} MotionModel;
/***********************************************************CommentEnd********/

/***********************************************************CommentBegin******
 *
 * -- MotionData -- motion data containing structs of different motion models
 *
 * Author:             K.S.
 *
 * Created:            8-Aug-96
 *	
 * Purpose:            To support different motion models within the
 *                     motion structure, the MotionData union is needed.
 * 
 * Modified:           -
 *
 *****************************************************************************/
typedef union {
  MVector     *mv;   /* motion vector for translational motion */
  MParameters *mp;   /* vector of coefficients for parametric motion model */
} MotionData;
/***********************************************************CommentEnd********/


/***********************************************************CommentBegin******
 *
 * -- Motion -- motion structure
 *
 * Author:             K.S.
 *
 * Created:            8-Aug-96
 *	
 * Purpose:            General motion structure.
 *                     To support different motion models within the
 *                     motion structure, the MotionData union is needed.
 *
 * Example:            To the x-subpel-component of a motion vector
 *                     is accessed by
 *                              Motion *m;
 *                              m->d->mv->sx;
 *                     if the motion model is TRANSLATION.
 *
 * Modified:           -
 *
 *****************************************************************************/
typedef struct {
  MotionData  *d;         /* Pointer to motion data */
  MotionModel mm;         /* motion model */
} Motion;
/***********************************************************CommentEnd********/


#include "motion/proto/imagemotion.p"
#include "motion/proto/motion.p"
#include "motion/proto/plot_motion.p"

#endif /* _MOTION_STRUCTS_H_ */
