/* bitio.c */
extern Bitstr *AllocBitstr(int n);
extern void FreeBitstr(Bitstr **b_p);
extern int CheckInBufferN(Bitstr *b);
extern int CheckInBuffer(Bitstr *b);
extern int ExtendBuffer(int n, Bitstr *b);
extern void ByteAlign(Bitstr *b);
extern int BitsToByteAlignment(Bitstr *bs);
extern int AbsBitPosIn(Bitstr *bs);
extern int GetBit(Bitstr *b, int *rbit_p);
extern int ShowBit(Bitstr *b, int offset, int *rbit_p);
extern int ShowBits(Bitstr *b, int offset, int n, int *rbit_p);
extern int ConsumeBits(Bitstr *b, int n);
extern int GetCodeword(Bitstr *b, int n, char *cw);
extern int ShowCodeword(Bitstr *b, int n, char *cw);
extern int GetCodewordIndex(Bitstr *b, char *ct[], int n, int *index_p);
extern int GetNumber(Bitstr *b, int n, int *num_p);
/* bitioX.c */
extern int GetBitX(Bitstr *b, int *rbit_p);
extern int ShowBitX(Bitstr *b, int offset, int *rbit_p);
extern int ShowBitsX(Bitstr *b, int offset, int n, int *rbit_p);
extern int ConsumeBitsX(Bitstr *b, int n);
extern int GetCodewordX(Bitstr *b, int n, char *cw);
extern int ShowCodewordX(Bitstr *b, int n, char *cw);
extern int GetCodewordIndexX(Bitstr *b, char *ct[], int n, int *index_p);
extern int GetNumberX(Bitstr *b, int n, int *num_p);
/* display.c */
extern unsigned char *rgb_image;
extern int coded_picture_width;
extern int coded_picture_height;
extern int chrom_width;
extern unsigned char pixel[256];
extern int visdepth;
extern void FreeXImage(void);
extern unsigned long PixelColor(Display *dpy, Colormap cmap, int r, int g, int b);
extern void init_display(int ww, int wh);
extern void exit_display(void);
extern void display_image(void);
/* dither.c */
extern void init_dither(void);
extern void ditherframe(Picture *p, unsigned char *dst);
/* h263dec.c */
extern int H263gotoNextSync(Bitstr *bs);
extern int H263LookupAnotherSync(Bitstr *bs);
extern Int GetPTYPEX(Bitstr *bs, H263picStruct *pic);
extern Int H263getPictureHeaderWoSync(Bitstr *bs, H263picStruct *pic);
extern Int H263getHeader(Bitstr *bs, Int *gn_p, H263picStruct *pic);
extern Int GetLevelsX(Bitstr *bs, Int *levels);
extern Int GetLastRunLevelX(Bitstr *bs, Int *last, Int *run, Int *level);
extern Int GetMVBaseModeX(Bitstr *bs, MVector *pv, MVector *mv);
extern Int H263ParseDecodePictureBaseMode(Bitstr *bs, H263picStruct *pic, Picture *refPict, Picture *pict);
extern Int H263ParseDecodeGOBBaseMode(Bitstr *bs, H263picStruct *pic, Picture *refPict, Picture *pict);
extern Int H263ParseDecodeGOB(Bitstr *bs, Picture *prevPict, Picture *pict);
extern Int H263ParseDecodeGOBDataBaseMode(Int gn, Bitstr *bs, H263picStruct *pic, Picture *prevPict, Picture *pict);
/* h263fast.c */
extern Void HalfPelBMCBaseModeFast(Byte *ip, int w, int h, MVector mv, Int xb, Int yb, Int s, Byte *mcIp);
extern Void HalfPelBMCFast(Byte *ip, int w, int h, MVector mv, Int xb, Int yb, Int s, Byte *mcIp);
/* h263misc.c */
extern H263picStruct *H263newPicStruct(void);
extern int H263allocPicStruct(H263picStruct *pic);
extern int H263freePicStruct(H263picStruct *pic);
extern void H263copyPicStruct(H263picStruct *pic1, H263picStruct *pic2);
extern void H263copyGobStruct(H263gobStruct *gob1, H263gobStruct *gob2);
extern H263mbStruct *H263allocMbStruct(int numberOfMVs, int numberOfBLKs, int numberOfLevels);
extern void H263copyMbStruct(int numberOfBLKs, int numberOfMVs, H263mbStruct *mb1, H263mbStruct *mb2);
extern H263blkStruct *H263allocBlkStruct(int numberOfLevels);
extern void H263copyBlkStruct(H263blkStruct *blk1, H263blkStruct *blk2);
/* h263parse.c */
extern int H263parseCbpyI(Bitstr *bs);
extern int H263parseMcbpcI(Bitstr *bs);
extern int H263parseMcbpcP(Bitstr *bs);
extern int H263parseModb(Bitstr *bs);
extern int H263parseMvd(Bitstr *bs);
extern int H263parseTcoef(Bitstr *bs);
/* h263quant.c */
extern Void H263dequant(Int *qcoeff, Int intradc, Int mbQuant, Int mode, Int cbp, Int *coeff);
/* idct.c */
extern Void IdctFastRow(Short *blk);
extern Void IdctFastColClip(Short *blk);
extern Void IdctFast(Int *coeff, Short *block);
extern Void IdctFastFloat(Int *coeff, Int *block);
extern Void IdctRef(Double *coeff, Int *block);
/* main.c */
extern FILE *debugfp;
extern char *debugfilename;
extern OptionsStruct Options;
extern int main(int argc, char *argv[]);
/* motion.c */
extern MVector *AllocMVector(void);
extern void FreeMVector(MVector **mv_p);
extern void ResetMVector(MVector *mv);
extern int ZeroMVector(MVector *mv);
extern int ZeroMVector2D(MVector *mv);
extern int AdjustSubpelMVector(MVector *mv);
extern void ClipMVector(int minX, int maxX, int minY, int maxY, MVector *mv);
extern int InvertMVector(MVector *mv);
extern int CopyMVector(MVector *mvIn, MVector *mvOut);
extern int CompareMVectors(MVector *mv1, MVector *mv2);
extern int CompareMVectors2D(MVector *mv1, MVector *mv2);
extern int AddMVectors(MVector *mvIn1, MVector *mvIn2, MVector *mvOut);
extern int SubtractMVectors(MVector *mvInPos, MVector *mvInNeg, MVector *mvOut);
extern void DivideBy2HalfPelMVector(MVector *mv1, MVector *mv2);
/* yuv.c */
extern void init_yuv2rgb(void);
extern void yuv4rgb(Picture *p, unsigned long *dst);
extern void yuv2rgb(Picture *p);
