/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	types.h
 *
 * Author:	K.S., T.W.
 * Created:	13-Jun-96 
 *                                                                         
 * Description: Common data types of compression group in LNT
 *
 * Notes: 	
 *
 * Modified:	
 *
 ***********************************************************HeaderEnd*********/


#ifndef _TYPES_H
#define _TYPES_H

#include <stdio.h>

/**************************************/
/**** GENERAL TYPE DEFINITIONS *******/
/**************************************/
#define Const const
typedef void                 Void       ;

typedef char                 Char       ;
typedef const    char        C_Char     ;

typedef unsigned char        Byte       ;
typedef Const    Byte        C_Byte     ;
typedef unsigned char        UChar      ;
typedef Const    UChar       C_UChar    ;

typedef short    int         Short      ;
typedef short    int         SInt       ;
typedef unsigned short       UShort     ;
typedef unsigned short       USInt      ;
typedef Const    short       C_Short    ;
typedef Const    short       C_SInt     ;
typedef Const    UShort      C_UShort   ;
typedef Const    UShort      C_USInt    ;

typedef          int         Int        ;
typedef Const    int         C_Int      ;

typedef unsigned int         UInt       ;
typedef Const    UInt        C_UInt     ;

typedef long     int         Long       ;
typedef Const    long        C_Long     ;

typedef unsigned long int    ULong      ;
typedef Const    ULong       C_ULong    ;

typedef float                Float      ;
typedef Const    float       C_Float    ;

typedef double               Double     ;
typedef Const    double      C_Double   ;

typedef FILE                 File       ;



                                         /********************************/
/* #ifndef C_IS_ANSI  */                 /* IF C ANSI MODE IS SUPPORTED  */
                                         /********************************/
#define _ANSI_ARGS_(argv)   argv         /* MACRO FOR PROTOTYPING        */
#define _P_(argv)           argv         /* <=> _ANSI_ARGS, BUT SHORTER! */
                                         /********************************/
/* #else */                              /* IF C ANSI IS NOT SUPPORTED   */
                                         /********************************/
/* #  define _ANSI_ARGS_(argv)   () */   /* MACRO FOR PROTOTYPING        */
/* #  define _P_(argv)           () */   /* <=> _ANSI_ARGS, BUT SHORTER! */
                                         /********************************/
/* #endif */


#endif /* _TYPES_H */


