/*
 * vsizes.h -- definition of video stream geometry
 *
 * 3.10.97, jw
 */

#define  SCIF_W		704
#define  SCIF_H		576
#define   CIF_W		352
#define   CIF_H		288
#define  QCIF_W		176
#define  QCIF_H		144
#define SQCIF_W		128
#define SQCIF_H		 96

#define  SCIF_WIDTH   SCIF_W
#define  SCIF_HEIGHT  SCIF_H
#define   CIF_WIDTH    CIF_W
#define   CIF_HEIGHT   CIF_H
#define  QCIF_WIDTH   QCIF_W
#define  QCIF_HEIGHT  QCIF_H
#define SQCIF_WIDTH  SQCIF_W
#define SQCIF_HEIGHT SQCIF_H

#define  PAL_W		768
#define  PAL_H		576
#define PAL2_W		384
#define PAL2_H		288
#define PAL4_W		192
#define PAL4_H		144

#define  NTSC_W		640
#define  NTSC_H		480
#define NTSC2_W		320
#define NTSC2_H		240
#define NTSC4_W		160
#define NTSC4_H		120

#define VSIZES_TABLE {				\
  {"QCIF",	QCIF_W, 	QCIF_H},	\
  {"CIF",	CIF_W, 		CIF_H },	\
  {"SCIF",	SCIF_W, 	SCIF_H},	\
						\
  {"PAL",	PAL_W, 		PAL_H },	\
  {"1/2 PAL",	PAL2_W, 	PAL2_H},	\
  {"PAL2",	PAL2_W, 	PAL2_H},	\
  {"PAL/2",	PAL2_W, 	PAL2_H},	\
  {"PAL 1/2",	PAL2_W, 	PAL2_H},	\
  {"1/4 PAL",	PAL4_W, 	PAL4_H},	\
  {"PAL4",	PAL4_W, 	PAL4_H},	\
  {"PAL/4",	PAL4_W, 	PAL4_H},	\
  {"PAL 1/4",	PAL4_W, 	PAL4_H},	\
						\
  {"NTSC",	NTSC_W, 	NTSC_H},	\
  {"1/2 NTSC",	NTSC2_W, 	NTSC2_H},	\
  {"NTSC2",	NTSC2_W, 	NTSC2_H},	\
  {"NTSC/2",	NTSC2_W, 	NTSC2_H},	\
  {"NTSC 1/2",	NTSC2_W, 	NTSC2_H},	\
  {"1/4 NTSC",	NTSC4_W, 	NTSC4_H},	\
  {"NTSC4",	NTSC4_W, 	NTSC4_H},	\
  {"NTSC/4",	NTSC4_W, 	NTSC4_H},	\
  {"NTSC 1/4",	NTSC4_W, 	NTSC4_H},	\
  {NULL,	0,		0}		\
}
