#include "defs.h"


#define MAX_PACKET_SIZE 1024

#define K_IL_INFO                  4

#define BYTES_PER_PACKET_IL_INFO(numLayer,kIlInfo) \
           (((1+1+(1+2)*(numLayer))+(kIlInfo)-1)/(kIlInfo))

#define HEADER_BYTES_PCK_MODE_0    3

#define NUM_IL  8       /* Corresponds to (max) buffersize in decoder */

/* Structures */

typedef struct {
  Byte *il[NUM_IL];          /* Interleaver */
  int  ilNumber[NUM_IL];     /* Interleaver number */
  int  status[NUM_IL];       /* Status: 0 = empty; 1 = full */
  int  bytesPerPckILInfo[NUM_IL];
  int  bytesPerPck[NUM_IL];
  int  bytesPerLayerPck[NUM_IL][NUM_LAYERS];
  int  numLayer[NUM_IL];
  int  end_f[NUM_IL];
  int  nRecPck[NUM_IL];      /* Number of received packets */
  int  *pckRec[NUM_IL];
  int  *pckValid[NUM_IL][NUM_LAYERS];  /* Number of valid (dec.) packets */
  int  kIl[NUM_IL][NUM_LAYERS]; /* k's of layer */
  int  nIlmax;             /* # packets per interleaver; 1 Byte */
  int  k_il_info;
  int  pckMode;               /* Packetization mode */

  /* Status for video decoder */
  int  videoDecIL[NUM_LAYERS];    /* Interleaver which is currently decoded
				     by the video decoder in this layer */
  int  videoDecLayerPck[NUM_LAYERS];   /* Packet which is currently decoded
					  by the video decoder in this layer */
  int  layerStartOffset[NUM_IL][NUM_LAYERS];
} InterleaverStack;


typedef struct {
  unsigned short bytesPerPck;        /* max. Packet size; 2 Bytes */
  unsigned char  nIlmax;             /* # packets per interleaver; 1 Byte */
  unsigned char  k_il_info;          /* k of packet info; 1 Byte */
  unsigned char  pckMode;            /* Packetization mode */
  unsigned char  maxLayers;          /* max. number of layers in stream */
} PackRSFileHeader;


typedef struct rspacketheader_struct
{
  unsigned short   bytesPerPck;        /* Packet size; 2 Bytes */
  unsigned char    ilNumber;
  unsigned short   packetNumber;
} RSPacketHeader;



#include "chacodec.p"
